/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;
import org.apache.commons.pipeline.validation.ConsumedTypes;
import org.apache.commons.pipeline.validation.ProducesConsumed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConsumedTypes(value={Object.class})
@ProducesConsumed
public class AddToCollectionStage<T>
extends BaseStage {
    private Collection<T> collection;

    public AddToCollectionStage(Collection<T> collection) {
        this(collection, true);
    }

    public AddToCollectionStage(Collection<T> collection, boolean synchronize) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 'collection' can not be null.");
        }
        this.collection = synchronize ? Collections.synchronizedCollection(collection) : collection;
    }

    @Override
    public void process(Object obj) throws StageException {
        this.collection.add(obj);
        this.emit(obj);
    }

    public Collection<T> getCollection() {
        return this.collection;
    }
}

