/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver.control;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.driver.control.DriverControlStrategy;
import org.apache.commons.pipeline.driver.control.PrioritizableStageDriver;
import org.apache.commons.pipeline.driver.control.StageProcessTimingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WallClockThresholdDriverControlStrategy
implements DriverControlStrategy {
    private long thresholdMs = 500L;
    private long allowableDelta;

    public WallClockThresholdDriverControlStrategy() {
    }

    public WallClockThresholdDriverControlStrategy(int thresholdMs) {
        this.thresholdMs = thresholdMs;
    }

    @Override
    public void handleEvents(List<PrioritizableStageDriver> drivers, List<StageProcessTimingEvent> events) {
        HashMap<Stage, Timing> timings = new HashMap<Stage, Timing>();
        long total = 0L;
        for (StageProcessTimingEvent ev : events) {
            Timing timing = (Timing)timings.get((Stage)ev.getSource());
            if (timing == null) {
                timing = new Timing();
                timings.put((Stage)ev.getSource(), timing);
            }
            timing.add(ev.getLatency());
            total += ev.getLatency();
        }
        long mean = total / (long)timings.size();
        for (PrioritizableStageDriver driver : drivers) {
            Timing timing = (Timing)timings.get(driver.getStage());
            long averageDuration = timing.duration / (long)timing.count;
            if (averageDuration < this.thresholdMs) continue;
            driver.increasePriority(1.0);
        }
    }

    public long getAllowableDelta() {
        return this.allowableDelta;
    }

    public void setAllowableDelta(long allowableDelta) {
        this.allowableDelta = allowableDelta;
    }

    private class Timing {
        private int count = 0;
        private long duration = 0L;

        Timing() {
        }

        public void add(long duration) {
            ++this.count;
            this.duration += duration;
        }
    }
}

