/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.driver.control.DriverControlStrategy;
import org.apache.commons.pipeline.driver.control.PrioritizableStageDriver;
import org.apache.commons.pipeline.driver.control.StageProcessTimingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentalDriverControlStrategy
implements DriverControlStrategy {
    private Log log = LogFactory.getLog(ExperimentalDriverControlStrategy.class);
    private int minDifferencePercent = 3;
    private Map<Stage, Tuple> lastTimings = new HashMap<Stage, Tuple>();
    private long allowableDelta;

    public ExperimentalDriverControlStrategy() {
    }

    public ExperimentalDriverControlStrategy(int minDifferencePercent) {
        if (minDifferencePercent < 0 || minDifferencePercent > 100) {
            throw new IllegalArgumentException("Minimum difference percent must be between 0 and 100");
        }
        this.minDifferencePercent = minDifferencePercent;
    }

    @Override
    public void handleEvents(List<PrioritizableStageDriver> drivers, List<StageProcessTimingEvent> events) {
        HashMap<Stage, Tuple> timings = new HashMap<Stage, Tuple>();
        for (StageProcessTimingEvent ev : events) {
            Tuple tuple = (Tuple)timings.get(ev.getSource());
            if (tuple == null) {
                tuple = new Tuple();
                timings.put((Stage)ev.getSource(), tuple);
            }
            tuple.add(ev.getLatency());
        }
        for (PrioritizableStageDriver driver : drivers) {
            Tuple mostRecentTiming = (Tuple)timings.get(driver.getStage());
            Tuple previousTiming = this.lastTimings.get(driver.getStage());
            double avgMostRecentDuration = mostRecentTiming.duration / (long)mostRecentTiming.count;
            if (previousTiming == null) {
                mostRecentTiming.lastAction = Action.Increase;
                driver.increasePriority(1.0);
            }
            if (previousTiming != null) {
                double avgPreviousTiming = previousTiming.duration / (long)previousTiming.count;
                double timingDifference = avgPreviousTiming - avgMostRecentDuration;
                this.log.debug((Object)("Performance went from " + avgPreviousTiming + " to " + avgMostRecentDuration + "(" + timingDifference + ")"));
                double minDifference = avgPreviousTiming * ((double)this.minDifferencePercent / 100.0);
                if (Math.abs(timingDifference) >= minDifference) {
                    Action randomAction;
                    if (timingDifference > 0.0) {
                        if (previousTiming.lastAction == Action.Increase) {
                            driver.increasePriority(1.0);
                            mostRecentTiming.lastAction = Action.Increase;
                        } else if (previousTiming.lastAction == Action.Decrease) {
                            driver.decreasePriority(1.0);
                            mostRecentTiming.lastAction = Action.Decrease;
                        } else {
                            this.log.debug((Object)"Significant performance change without a previous action: RANDOM action");
                            randomAction = this.getRandomAction();
                            mostRecentTiming.lastAction = randomAction;
                            randomAction.execute(driver);
                        }
                    } else if (previousTiming.lastAction == Action.Increase) {
                        driver.decreasePriority(1.0);
                        mostRecentTiming.lastAction = Action.Decrease;
                    } else if (previousTiming.lastAction == Action.Decrease) {
                        driver.increasePriority(1.0);
                        mostRecentTiming.lastAction = Action.Increase;
                    } else {
                        this.log.debug((Object)"Significant performance change without a previous action: RANDOM action");
                        randomAction = this.getRandomAction();
                        mostRecentTiming.lastAction = randomAction;
                        randomAction.execute(driver);
                    }
                } else {
                    mostRecentTiming.lastAction = Action.None;
                }
            }
            this.log.debug((Object)("Action=" + (Object)((Object)mostRecentTiming.lastAction) + ", current priority=" + driver.getPriority()));
            this.lastTimings.put(driver.getStage(), mostRecentTiming);
        }
    }

    private Action getRandomAction() {
        int val = new Random().nextInt();
        if (val < 0) {
            val *= -1;
        }
        int actionVal = val % 3;
        switch (actionVal) {
            case 0: {
                return Action.None;
            }
            case 1: {
                return Action.Increase;
            }
            case 2: {
                return Action.Decrease;
            }
        }
        throw new IllegalStateException();
    }

    public long getAllowableDelta() {
        return this.allowableDelta;
    }

    public void setAllowableDelta(long allowableDelta) {
        this.allowableDelta = allowableDelta;
    }

    private class Tuple {
        private int count = 0;
        private long duration = 0L;
        private Action lastAction = Action.None;

        Tuple() {
        }

        public void add(long duration) {
            ++this.count;
            this.duration += duration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        Decrease{

            void execute(PrioritizableStageDriver driver) {
                driver.decreasePriority(1.0);
            }
        }
        ,
        Increase{

            void execute(PrioritizableStageDriver driver) {
                driver.increasePriority(1.0);
            }
        }
        ,
        None{

            void execute(PrioritizableStageDriver driver) {
            }
        };


        abstract void execute(PrioritizableStageDriver var1);
    }
}

