/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.driver.control.DriverControlStrategy;
import org.apache.commons.pipeline.driver.control.PrioritizableStageDriver;
import org.apache.commons.pipeline.driver.control.StageProcessTimingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualizingDriverControlStrategy
implements DriverControlStrategy {
    Log log = LogFactory.getLog(EqualizingDriverControlStrategy.class);
    private long allowableDelta;

    @Override
    public void handleEvents(List<PrioritizableStageDriver> drivers, List<StageProcessTimingEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        HashMap<Stage, Tuple> timings = new HashMap<Stage, Tuple>();
        long total = 0L;
        for (StageProcessTimingEvent stageProcessTimingEvent : events) {
            Tuple tuple = (Tuple)timings.get((Stage)stageProcessTimingEvent.getSource());
            if (tuple == null) {
                tuple = new Tuple();
                timings.put((Stage)stageProcessTimingEvent.getSource(), tuple);
            }
            tuple.add(stageProcessTimingEvent.getLatency());
            total += stageProcessTimingEvent.getLatency();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Events handled: " + events.size()));
            this.log.debug((Object)"Stage latencies: ");
            for (Map.Entry entry : timings.entrySet()) {
                this.log.debug((Object)(entry.getKey() + ": " + ((Tuple)entry.getValue()).duration / (long)((Tuple)entry.getValue()).count + "; "));
            }
            this.log.debug((Object)("Total latency: " + total));
        }
        double mean = total / (long)events.size();
        for (PrioritizableStageDriver driver : drivers) {
            Tuple tuple = (Tuple)timings.get(driver.getStage());
            if (tuple == null) continue;
            long averageDuration = tuple.duration / (long)tuple.count;
            if ((double)averageDuration > mean + (double)this.allowableDelta) {
                this.log.debug((Object)("Increasing priority for stage " + driver.getStage() + " with average duration " + averageDuration));
                driver.increasePriority(1.0);
                continue;
            }
            if (!((double)averageDuration < mean - (double)this.allowableDelta)) continue;
            driver.decreasePriority(1.0);
            this.log.debug((Object)("Decreasing priority for stage " + driver.getStage() + " with average duration " + averageDuration));
        }
    }

    public long getAllowableDelta() {
        return this.allowableDelta;
    }

    public void setAllowableDelta(long allowableDelta) {
        this.allowableDelta = allowableDelta;
    }

    private static class Tuple {
        private int count = 0;
        private long duration = 0L;

        Tuple() {
        }

        public void add(long duration) {
            ++this.count;
            this.duration += duration;
        }
    }
}

