/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver.control;

import java.util.concurrent.TimeUnit;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.driver.FaultTolerance;
import org.apache.commons.pipeline.driver.control.BalancedPoolStageDriver;
import org.apache.commons.pipeline.driver.control.PrioritizableStageDriverFactory;
import org.apache.commons.pipeline.util.BlockingQueueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalancedPoolStageDriverFactory
implements PrioritizableStageDriverFactory<BalancedPoolStageDriver> {
    private int initialThreads = 0;
    private BlockingQueueFactory queueFactory = new BlockingQueueFactory.LinkedBlockingQueueFactory();
    private FaultTolerance faultTolerance = FaultTolerance.NONE;
    private long timeout = 500L;
    private TimeUnit timeoutTimeUnit = TimeUnit.MILLISECONDS;

    @Override
    public BalancedPoolStageDriver createStageDriver(Stage stage, StageContext context) {
        return new BalancedPoolStageDriver(stage, context, this.queueFactory, this.initialThreads, this.faultTolerance, this.timeout, this.timeoutTimeUnit);
    }

    public int getInitialThreads() {
        return this.initialThreads;
    }

    public void setInitialThreads(int initialThreads) {
        this.initialThreads = initialThreads;
    }

    public BlockingQueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    public void setQueueFactory(BlockingQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    public FaultTolerance getFaultTolerance() {
        return this.faultTolerance;
    }

    public void setFaultTolerance(FaultTolerance faultTolerance) {
        this.faultTolerance = faultTolerance;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public void setTimeoutTimeUnit(TimeUnit timeoutTimeUnit) {
        this.timeoutTimeUnit = timeoutTimeUnit;
    }

    @Override
    public void setInitialPriority(double priority) {
        this.setInitialThreads((int)priority);
    }
}

