/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver;

import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageDriver;
import org.apache.commons.pipeline.StageDriverFactory;
import org.apache.commons.pipeline.driver.FaultTolerance;
import org.apache.commons.pipeline.driver.ThreadPoolStageDriver;
import org.apache.commons.pipeline.util.BlockingQueueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolStageDriverFactory
implements StageDriverFactory {
    private int numThreads = 1;
    private BlockingQueueFactory<?> queueFactory = new BlockingQueueFactory.LinkedBlockingQueueFactory();
    private long timeout = 500L;
    private FaultTolerance faultTolerance = FaultTolerance.NONE;

    public StageDriver createStageDriver(Stage stage, StageContext context) {
        try {
            return new ThreadPoolStageDriver(stage, context, this.queueFactory.createQueue(), this.timeout, this.faultTolerance, this.numThreads);
        }
        catch (Exception e) {
            throw new IllegalStateException("Instantiation of driver failed due to illegal factory state.", e);
        }
    }

    public BlockingQueueFactory<?> getQueueFactory() {
        return this.queueFactory;
    }

    public void setQueueFactory(BlockingQueueFactory<?> queueFactory) {
        this.queueFactory = queueFactory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public FaultTolerance getFaultTolerance() {
        return this.faultTolerance;
    }

    public void setFaultTolerance(FaultTolerance faultTolerance) {
        this.faultTolerance = faultTolerance;
    }

    public void setFaultToleranceLevel(String level) {
        this.faultTolerance = FaultTolerance.valueOf(level);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }
}

