/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.Feeder;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageDriver;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.driver.AbstractStageDriver;
import org.apache.commons.pipeline.driver.FaultTolerance;

public class SynchronousStageDriver
extends AbstractStageDriver {
    private final Log log = LogFactory.getLog(SynchronousStageDriver.class);
    private Queue<Object> queue = new LinkedList<Object>();
    private final Feeder feeder = new Feeder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void feed(Object obj) {
            block7: {
                SynchronousStageDriver synchronousStageDriver = SynchronousStageDriver.this;
                synchronized (synchronousStageDriver) {
                    if (SynchronousStageDriver.this.currentState == StageDriver.State.ERROR) {
                        throw new IllegalStateException("Unable to process data: driver in fatal error state.");
                    }
                    if (SynchronousStageDriver.this.currentState != StageDriver.State.RUNNING) {
                        SynchronousStageDriver.this.queue.add(obj);
                        return;
                    }
                }
                try {
                    SynchronousStageDriver.this.stage.process(obj);
                }
                catch (StageException e) {
                    SynchronousStageDriver.this.recordProcessingException(obj, e);
                    if (SynchronousStageDriver.this.faultTolerance != FaultTolerance.NONE) break block7;
                    throw SynchronousStageDriver.this.fatalError(e);
                }
            }
        }
    };

    public SynchronousStageDriver(Stage stage, StageContext context, FaultTolerance faultTolerance) {
        super(stage, context, faultTolerance);
    }

    public Feeder getFeeder() {
        return this.feeder;
    }

    public synchronized void start() throws StageException {
        if (this.currentState == StageDriver.State.STOPPED) {
            try {
                this.stage.preprocess();
                this.setState(StageDriver.State.RUNNING);
            }
            catch (StageException e) {
                throw this.fatalError(e);
            }
            while (!this.queue.isEmpty()) {
                this.getFeeder().feed(this.queue.remove());
            }
        } else {
            throw new IllegalStateException("Illegal attempt to start driver from state: " + (Object)((Object)this.currentState));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void finish() throws StageException {
        if (this.currentState != StageDriver.State.RUNNING) throw new IllegalStateException("Driver is not running (current state: " + (Object)((Object)this.currentState) + ")");
        try {
            this.testAndSetState(StageDriver.State.RUNNING, StageDriver.State.STOP_REQUESTED);
            if (this.currentState != StageDriver.State.STOP_REQUESTED) return;
            this.stage.postprocess();
            return;
        }
        catch (StageException e) {
            throw this.fatalError(e);
        }
        finally {
            this.stage.release();
            this.testAndSetState(StageDriver.State.STOP_REQUESTED, StageDriver.State.STOPPED);
        }
    }

    private RuntimeException fatalError(Throwable t) {
        try {
            this.setState(StageDriver.State.ERROR);
            this.recordFatalError(t);
            this.stage.release();
            this.notifyAll();
        }
        catch (Exception e) {
            this.recordFatalError(e);
        }
        return new RuntimeException("Fatal error halted processing of stage: " + this.stage);
    }
}

