/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.driver;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pipeline.Feeder;
import org.apache.commons.pipeline.ProcessingException;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageDriver;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.driver.FaultTolerance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStageDriver
implements StageDriver {
    protected Stage stage;
    protected StageContext context;
    protected volatile StageDriver.State currentState = StageDriver.State.STOPPED;
    protected FaultTolerance faultTolerance = FaultTolerance.NONE;
    protected List<ProcessingException> processingExceptions = new ArrayList<ProcessingException>();
    protected List<Throwable> errors = new ArrayList<Throwable>();

    public AbstractStageDriver(Stage stage, StageContext context) {
        this(stage, context, FaultTolerance.NONE);
    }

    public AbstractStageDriver(Stage stage, StageContext context, FaultTolerance faultTolerance) {
        if (stage == null) {
            throw new IllegalArgumentException("Stage may not be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context may not be null.");
        }
        this.stage = stage;
        this.context = context;
        this.faultTolerance = faultTolerance;
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public abstract Feeder getFeeder();

    @Override
    public StageDriver.State getState() {
        return this.currentState;
    }

    protected synchronized boolean isInState(StageDriver.State ... states) {
        for (StageDriver.State state : states) {
            if (state != this.currentState) continue;
            return true;
        }
        return false;
    }

    protected synchronized void setState(StageDriver.State nextState) {
        this.currentState = nextState;
        this.notifyAll();
    }

    protected synchronized boolean testAndSetState(StageDriver.State testState, StageDriver.State nextState) {
        if (this.currentState == testState) {
            this.setState(nextState);
            return true;
        }
        return false;
    }

    @Override
    public abstract void start() throws StageException;

    @Override
    public abstract void finish() throws StageException;

    public final void setFaultTolerance(FaultTolerance faultTolerance) {
        this.faultTolerance = faultTolerance;
    }

    public final FaultTolerance getFaultTolerance() {
        return this.faultTolerance;
    }

    protected void recordFatalError(Throwable error) {
        this.errors.add(error);
    }

    @Override
    public List<Throwable> getFatalErrors() {
        return this.errors;
    }

    protected void recordProcessingException(Object data, Throwable error) {
        ProcessingException ex = new ProcessingException(this.stage, error, data, this.getState());
        this.processingExceptions.add(ex);
    }

    @Override
    public List<ProcessingException> getProcessingExceptions() {
        return this.processingExceptions;
    }
}

