/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.pipeline.Pipeline;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageDriverFactory;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineRuleSet
extends RuleSetBase {
    private static Class[] addBranchTypes = new Class[]{String.class, Pipeline.class};
    private static Class[] setEnvTypes = new Class[]{String.class, Object.class};
    private List<RuleSet> nestedRuleSets;

    public PipelineRuleSet() {
    }

    public PipelineRuleSet(List<RuleSet> nestedRuleSets) {
        this.nestedRuleSets = nestedRuleSets;
    }

    public void addRuleInstances(Digester digester) {
        PipelineFactory pipelineFactory = new PipelineFactory();
        StageDriverFactoryFactory driverFactoryFactory = new StageDriverFactoryFactory();
        digester.addFactoryCreate("pipeline", (ObjectCreationFactory)pipelineFactory);
        digester.addSetProperties("pipeline");
        digester.addRule("pipeline", (Rule)new PipelineDriverFactoriesRule());
        digester.addFactoryCreate("*/branch/pipeline", (ObjectCreationFactory)pipelineFactory);
        digester.addRule("*/branch/pipeline", (Rule)new CallMethodRule(1, "addBranch", 2, addBranchTypes));
        digester.addCallParam("*/branch/pipeline", 0, "key");
        digester.addCallParam("*/branch/pipeline", 1, 0);
        digester.addRule("*/branch/pipeline", (Rule)new PipelineDriverFactoriesRule());
        digester.addObjectCreate("*/pipeline/env/object", "java.lang.Object", "className");
        digester.addSetProperties("*/pipeline/env/object");
        digester.addRule("*/pipeline/env/object", (Rule)new CallMethodRule(1, "setEnv", 2, setEnvTypes));
        digester.addCallParam("*/pipeline/env/object", 0, "key");
        digester.addCallParam("*/pipeline/env/object", 1, 0);
        digester.addRule("*/pipeline/env/value", (Rule)new CallMethodRule(0, "setEnv", 2, setEnvTypes));
        digester.addCallParam("*/pipeline/env/value", 0, "key");
        digester.addCallParam("*/pipeline/env/value", 1);
        digester.addObjectCreate("*/pipeline/listener", "org.apache.commons.pipeline.StageEventListener", "className");
        digester.addSetProperties("*/pipeline/listener");
        digester.addSetNext("*/pipeline/listener", "registerListener", "org.apache.commons.pipeline.StageEventListener");
        digester.addFactoryCreate("*/pipeline/driverFactory", (ObjectCreationFactory)driverFactoryFactory);
        digester.addSetProperties("*/pipeline/driverFactory");
        digester.addObjectCreate("*/driverFactory", "org.apache.commons.pipeline.StageDriverFactory", "className");
        digester.addSetProperties("*/driverFactory");
        digester.addSetNext("*/driverFactory", "setWrappedSDF", "org.apache.commons.pipeline.StageDriverFactory");
        digester.addObjectCreate("*/pipeline/lifecycleJob", "org.apache.commons.pipeline.PipelineLifecycleJob", "className");
        digester.addSetProperties("*/pipeline/lifecycleJob");
        digester.addSetNext("*/pipeline/lifecycleJob", "addLifecycleJob", "org.apache.commons.pipeline.PipelineLifecycleJob");
        digester.addObjectCreate("*/property", "java.lang.Object", "className");
        digester.addSetProperties("*/property");
        digester.addRule("*/property", (Rule)new SetNestedPropertyObjectRule());
        digester.addObjectCreate("*/pipeline/stage", "org.apache.commons.pipeline.BaseStage", "className");
        digester.addSetProperties("*/pipeline/stage");
        digester.addRule("*/pipeline/stage", (Rule)new PipelineAddStageRule());
        digester.addRule("*/pipeline/feed/value", (Rule)new PipelineFeedValueRule());
        digester.addObjectCreate("*/pipeline/feed/object", "java.lang.Object", "className");
        digester.addSetProperties("*/pipeline/feed/object");
        digester.addRule("*/pipeline/feed/object", (Rule)new PipelineFeedObjectRule());
    }

    private class PipelineFeedObjectRule
    extends Rule {
        private PipelineFeedObjectRule() {
        }

        public void end(String namespace, String name) throws Exception {
            super.end(namespace, name);
            Pipeline pipeline = (Pipeline)this.digester.peek(1);
            pipeline.getSourceFeeder().feed(this.digester.peek());
        }
    }

    private class PipelineFeedValueRule
    extends Rule {
        private PipelineFeedValueRule() {
        }

        public void body(String namespace, String name, String text) throws Exception {
            Pipeline pipeline = (Pipeline)this.digester.peek();
            pipeline.getSourceFeeder().feed(text);
            super.body(namespace, name, text);
        }
    }

    private class PipelineAddStageRule
    extends Rule {
        private PipelineAddStageRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            this.digester.push("org.apache.commons.pipeline.config.DriverFactoryIds", (Object)attributes.getValue("driverFactoryId"));
            super.begin(namespace, name, attributes);
        }

        public void end(String namespace, String name) throws Exception {
            super.end(namespace, name);
            String factoryId = (String)this.digester.pop("org.apache.commons.pipeline.config.DriverFactoryIds");
            Map driverFactories = (Map)this.digester.peek("org.apache.commons.pipeline.config.DriverFactories");
            StageDriverFactory factory = (StageDriverFactory)driverFactories.get(factoryId);
            Stage stage = (Stage)this.digester.peek();
            Pipeline pipeline = (Pipeline)this.digester.peek(1);
            pipeline.addStage(stage, factory);
        }
    }

    private class StageDriverFactoryFactory
    extends AbstractObjectCreationFactory {
        private StageDriverFactoryFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            Map driverFactories = (Map)this.digester.peek("org.apache.commons.pipeline.config.DriverFactories");
            String className = attributes.getValue("className");
            String id = attributes.getValue("id");
            Class<?> clazz = Class.forName(className);
            if (!StageDriverFactory.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + clazz + " does not implement StageDriverFactory.");
            }
            StageDriverFactory factory = (StageDriverFactory)clazz.newInstance();
            driverFactories.put(id, factory);
            return factory;
        }
    }

    private class SetNestedPropertyObjectRule
    extends Rule {
        String propName;

        private SetNestedPropertyObjectRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            this.propName = attributes.getValue("propName");
            super.begin(namespace, name, attributes);
        }

        public void end(String namespace, String name) throws Exception {
            super.end(namespace, name);
            BeanUtils.setProperty((Object)this.digester.peek(1), (String)this.propName, (Object)this.digester.peek());
        }
    }

    private class PipelineDriverFactoriesRule
    extends Rule {
        private PipelineDriverFactoriesRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            this.digester.push("org.apache.commons.pipeline.config.DriverFactories", new HashMap());
            super.begin(namespace, name, attributes);
        }

        public void end(String namespace, String name) throws Exception {
            super.end(namespace, name);
            this.digester.pop("org.apache.commons.pipeline.config.DriverFactories");
        }
    }

    private class PipelineFactory
    extends AbstractObjectCreationFactory {
        private PipelineFactory() {
        }

        public Object createObject(Attributes attributes) throws Exception {
            String configURI = attributes.getValue("configURI");
            if (configURI == null) {
                return new Pipeline();
            }
            Digester subDigester = new Digester();
            if (PipelineRuleSet.this.nestedRuleSets != null) {
                for (RuleSet ruleset : PipelineRuleSet.this.nestedRuleSets) {
                    subDigester.addRuleSet(ruleset);
                }
                Pipeline pipeline = (Pipeline)subDigester.parse(configURI);
                return pipeline;
            }
            throw new IllegalStateException("Unable to parse branch configuration file: No parsing rules provided to PipelineRuleSet constructor.");
        }
    }
}

