/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.pipeline.Pipeline;
import org.apache.commons.pipeline.PipelineCreationException;
import org.apache.commons.pipeline.PipelineFactory;
import org.apache.commons.pipeline.config.PipelineRuleSet;
import org.xml.sax.SAXException;

public class DigesterPipelineFactory
implements PipelineFactory {
    private List<RuleSet> ruleSets = new ArrayList<RuleSet>();
    private URL confURL;

    public DigesterPipelineFactory(URL confURL) {
        if (confURL == null) {
            throw new IllegalArgumentException("Configuration file URL may not be null.");
        }
        this.confURL = confURL;
        this.ruleSets.add((RuleSet)new PipelineRuleSet(this.ruleSets));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pipeline createPipeline() throws PipelineCreationException {
        Pipeline pipeline;
        Digester digester = new Digester();
        this.initDigester(digester);
        InputStream in = this.confURL.openStream();
        try {
            pipeline = (Pipeline)digester.parse(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PipelineCreationException("An IOException occurred reading the configuration file: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new PipelineCreationException("A formatting error exists in the configuration file: " + e.getMessage(), e);
            }
        }
        in.close();
        return pipeline;
    }

    public void initDigester(Digester digester) {
        Iterator<RuleSet> iter = this.ruleSets.iterator();
        while (iter.hasNext()) {
            digester.addRuleSet(iter.next());
        }
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.ruleSets.add(ruleSet);
    }

    public static void main(String[] argv) {
        try {
            File configFile = new File(argv[0]);
            DigesterPipelineFactory factory = new DigesterPipelineFactory(configFile.toURL());
            Pipeline pipeline = factory.createPipeline();
            for (int i = 1; i < argv.length; ++i) {
                pipeline.getSourceFeeder().feed(argv[i]);
            }
            System.out.println("Pipeline created, about to begin processing...");
            pipeline.start();
            pipeline.finish();
            System.out.println("Pipeline successfully finished processing. See logs for details.");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

