/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.pipeline.Feeder;
import org.apache.commons.pipeline.PipelineLifecycleJob;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageDriver;
import org.apache.commons.pipeline.StageDriverFactory;
import org.apache.commons.pipeline.StageEventListener;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.validation.PipelineValidator;
import org.apache.commons.pipeline.validation.ValidationException;
import org.apache.commons.pipeline.validation.ValidationFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
implements Runnable,
StageContext {
    public static final String MAIN_BRANCH = "main";
    private final LinkedList<StageDriver> drivers;
    private final Map<Stage, StageDriver> driverMap;
    private final LinkedList<Stage> stages;
    private final Map<String, Pipeline> branches;
    private Pipeline parent;
    private final List<StageEventListener> listeners;
    private PipelineValidator validator;
    private Feeder terminalFeeder = Feeder.VOID;
    private Map<String, Object> env = Collections.synchronizedMap(new HashMap());
    private Collection<PipelineLifecycleJob> lifecycleJobs = new ArrayList<PipelineLifecycleJob>();

    public Pipeline() {
        this.drivers = new LinkedList();
        this.driverMap = new HashMap<Stage, StageDriver>();
        this.stages = new LinkedList();
        this.branches = new HashMap<String, Pipeline>();
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void registerListener(StageEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<StageEventListener> getRegisteredListeners() {
        return this.listeners;
    }

    @Override
    public void raise(final EventObject ev) {
        new Thread(){

            public void run() {
                Pipeline root = Pipeline.this;
                while (root.parent != null) {
                    root = root.parent;
                }
                root.notifyListeners(ev);
            }
        }.start();
    }

    private void notifyListeners(EventObject ev) {
        for (StageEventListener listener : this.listeners) {
            listener.notify(ev);
        }
        for (Pipeline branch : this.branches.values()) {
            branch.notifyListeners(ev);
        }
    }

    @Override
    public Feeder getDownstreamFeeder(Stage stage) {
        if (stage == null) {
            throw new IllegalArgumentException("Unable to look up downstream feeder for null stage.");
        }
        if (stage == this.drivers.getLast().getStage()) {
            return this.terminalFeeder;
        }
        for (int i = this.drivers.size() - 2; i >= 0; --i) {
            if (stage != this.drivers.get(i).getStage()) continue;
            return this.drivers.get(i + 1).getFeeder();
        }
        throw new IllegalStateException("Unable to find stage " + stage + " in pipeline.");
    }

    @Override
    public Feeder getBranchFeeder(String branch) {
        if (!this.getBranches().containsKey(branch)) {
            throw new IllegalStateException("Unable to find branch in pipeline: '" + branch + "'");
        }
        return this.branches.get(branch).getSourceFeeder();
    }

    @Override
    public Object getEnv(String key) {
        return this.env.get(key);
    }

    public void setEnv(String key, Object value) {
        this.env.put(key, value);
    }

    public final void addStage(Stage stage, StageDriverFactory driverFactory) throws ValidationException {
        List<ValidationFailure> errors;
        if (stage == null) {
            throw new IllegalArgumentException("Argument \"stage\" for call to Pipeline.addStage() may not be null.");
        }
        if (this.validator != null && (errors = this.validator.validateAddStage(this, stage, driverFactory)) != null && !errors.isEmpty()) {
            throw new ValidationException("An error occurred adding stage " + stage.toString(), errors);
        }
        stage.init(this);
        this.stages.add(stage);
        Object driver = driverFactory.createStageDriver(stage, this);
        this.driverMap.put(stage, (StageDriver)driver);
        this.drivers.add((StageDriver)driver);
    }

    public final List<Stage> getStages() {
        return Collections.unmodifiableList(this.stages);
    }

    public final StageDriver getStageDriver(Stage stage) {
        return this.driverMap.get(stage);
    }

    public final List<StageDriver> getStageDrivers() {
        return Collections.unmodifiableList(this.drivers);
    }

    public void addBranch(String key, Pipeline branch) throws ValidationException {
        List<ValidationFailure> errors;
        if (key == null) {
            throw new IllegalArgumentException("Branch key may not be null.");
        }
        if (MAIN_BRANCH.equalsIgnoreCase(key)) {
            throw new IllegalArgumentException("Branch key name \"main\" is reserved.");
        }
        if (branch == null) {
            throw new IllegalArgumentException("Illegal attempt to set reference to null branch.");
        }
        if (branch == this || branch.hasBranch(this)) {
            throw new IllegalArgumentException("Illegal attempt to set reference to self as a branch (infinite recursion potential)");
        }
        if (this.validator != null && (errors = this.validator.validateAddBranch(this, key, branch)) != null && !errors.isEmpty()) {
            throw new ValidationException("An error occurred adding branch pipeline " + branch, errors);
        }
        branch.parent = this;
        this.branches.put(key, branch);
    }

    public Map<String, Pipeline> getBranches() {
        return Collections.unmodifiableMap(this.branches);
    }

    private boolean hasBranch(Pipeline pipeline) {
        if (this.branches.containsValue(pipeline)) {
            return true;
        }
        for (Pipeline branch : this.branches.values()) {
            if (!branch.hasBranch(pipeline)) continue;
            return true;
        }
        return false;
    }

    public Feeder getSourceFeeder() {
        if (this.drivers.isEmpty()) {
            return this.terminalFeeder;
        }
        return this.drivers.peek().getFeeder();
    }

    public Feeder getTerminalFeeder() {
        return this.terminalFeeder;
    }

    public void setTerminalFeeder(Feeder terminalFeeder) {
        this.terminalFeeder = terminalFeeder;
    }

    public void addLifecycleJob(PipelineLifecycleJob job) {
        this.lifecycleJobs.add(job);
    }

    public void start() throws StageException {
        for (PipelineLifecycleJob job : this.lifecycleJobs) {
            job.onStart(this);
        }
        for (StageDriver driver : this.drivers) {
            driver.start();
        }
        for (Pipeline branch : this.branches.values()) {
            branch.start();
        }
    }

    public void finish() throws StageException {
        for (StageDriver driver : this.drivers) {
            driver.finish();
        }
        for (Pipeline pipeline : this.branches.values()) {
            pipeline.finish();
        }
        for (PipelineLifecycleJob job : this.lifecycleJobs) {
            job.onFinish(this);
        }
    }

    @Override
    public void run() {
        try {
            this.start();
            this.finish();
        }
        catch (StageException e) {
            throw new RuntimeException(e);
        }
    }

    public PipelineValidator getValidator() {
        return this.validator;
    }

    public void setValidator(PipelineValidator validator) {
        this.validator = validator;
    }

    public Pipeline getParent() {
        return this.parent;
    }
}

