/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.gamma.LogGamma;

public final class LogFactorial {
    private static final int FACTORIALS_CACHE_SIZE = 21;
    private final double[] logFactorials;

    private LogFactorial(int numValues, double[] cache) {
        int i;
        if (numValues < 0) {
            throw new CombinatoricsException("Number {0} is negative", numValues);
        }
        this.logFactorials = new double[numValues];
        int beginCopy = 2;
        int endCopy = cache == null || cache.length <= 2 ? 2 : (cache.length <= numValues ? cache.length : numValues);
        for (i = 2; i < endCopy; ++i) {
            this.logFactorials[i] = cache[i];
        }
        for (i = endCopy; i < numValues; ++i) {
            this.logFactorials[i] = this.logFactorials[i - 1] + Math.log(i);
        }
    }

    public static LogFactorial create() {
        return new LogFactorial(0, null);
    }

    public LogFactorial withCache(int cacheSize) {
        return new LogFactorial(cacheSize, this.logFactorials);
    }

    public double value(int n) {
        if (n < 0) {
            throw new CombinatoricsException("Number {0} is negative", n);
        }
        if (n < this.logFactorials.length) {
            return this.logFactorials[n];
        }
        if (n < 21) {
            return Math.log(Factorial.value(n));
        }
        return LogGamma.value((double)((double)n + 1.0));
    }
}

