/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math4.neuralnet.DistanceMeasure;
import org.apache.commons.math4.neuralnet.Neuron;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public class MapRanking {
    private final List<Neuron> map = new ArrayList<Neuron>();
    private final DistanceMeasure distance;

    public MapRanking(Iterable<Neuron> neurons, DistanceMeasure distance) {
        this.distance = distance;
        for (Neuron n : neurons) {
            this.map.add(n);
        }
    }

    public List<Neuron> rank(double[] features) {
        return this.rank(features, this.map.size());
    }

    public List<Neuron> rank(double[] features, int max) {
        if (max <= 0) {
            throw new NeuralNetException("Number {0} is not strictly positive", max);
        }
        int m = max <= this.map.size() ? max : this.map.size();
        ArrayList<PairNeuronDouble> list = new ArrayList<PairNeuronDouble>(m);
        for (Neuron n : this.map) {
            double d = this.distance.applyAsDouble(n.getFeatures(), features);
            PairNeuronDouble p = new PairNeuronDouble(n, d);
            if (list.size() < m) {
                list.add(p);
                if (list.size() <= 1) continue;
                Collections.sort(list, PairNeuronDouble.COMPARATOR);
                continue;
            }
            int last = list.size() - 1;
            if (PairNeuronDouble.COMPARATOR.compare(p, (PairNeuronDouble)list.get(last)) >= 0) continue;
            list.set(last, p);
            if (last <= 0) continue;
            Collections.sort(list, PairNeuronDouble.COMPARATOR);
        }
        ArrayList<Neuron> result = new ArrayList<Neuron>(m);
        for (PairNeuronDouble p : list) {
            result.add(p.getNeuron());
        }
        return result;
    }

    private static class PairNeuronDouble {
        static final Comparator<PairNeuronDouble> COMPARATOR = new Comparator<PairNeuronDouble>(){

            @Override
            public int compare(PairNeuronDouble o1, PairNeuronDouble o2) {
                return Double.compare(o1.value, o2.value);
            }
        };
        private final Neuron neuron;
        private final double value;

        PairNeuronDouble(Neuron neuron, double value) {
            this.neuron = neuron;
            this.value = value;
        }

        public Neuron getNeuron() {
            return this.neuron;
        }
    }
}

