/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;

public class JCSConfiguration<K, V>
implements CompleteConfiguration<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final boolean storeByValue;
    private final boolean readThrough;
    private final boolean writeThrough;
    private final Factory<CacheLoader<K, V>> cacheLoaderFactory;
    private final Factory<CacheWriter<? super K, ? super V>> cacheWristerFactory;
    private final Factory<ExpiryPolicy> expiryPolicyFactory;
    private final Set<CacheEntryListenerConfiguration<K, V>> cacheEntryListenerConfigurations;
    private volatile boolean statisticsEnabled;
    private volatile boolean managementEnabled;

    public JCSConfiguration(Configuration<K, V> configuration, Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        if (configuration instanceof CompleteConfiguration) {
            CompleteConfiguration cConfiguration = (CompleteConfiguration)configuration;
            this.storeByValue = configuration.isStoreByValue();
            this.readThrough = cConfiguration.isReadThrough();
            this.writeThrough = cConfiguration.isWriteThrough();
            this.statisticsEnabled = cConfiguration.isStatisticsEnabled();
            this.managementEnabled = cConfiguration.isManagementEnabled();
            this.cacheLoaderFactory = cConfiguration.getCacheLoaderFactory();
            this.cacheWristerFactory = cConfiguration.getCacheWriterFactory();
            this.expiryPolicyFactory = cConfiguration.getExpiryPolicyFactory();
            this.cacheEntryListenerConfigurations = new HashSet<CacheEntryListenerConfiguration<K, V>>();
            Iterable entryListenerConfigurations = cConfiguration.getCacheEntryListenerConfigurations();
            if (entryListenerConfigurations != null) {
                for (CacheEntryListenerConfiguration kvCacheEntryListenerConfiguration : entryListenerConfigurations) {
                    this.cacheEntryListenerConfigurations.add(kvCacheEntryListenerConfiguration);
                }
            }
        } else {
            this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
            this.storeByValue = true;
            this.readThrough = false;
            this.writeThrough = false;
            this.statisticsEnabled = false;
            this.managementEnabled = false;
            this.cacheLoaderFactory = null;
            this.cacheWristerFactory = null;
            this.cacheEntryListenerConfigurations = new HashSet<CacheEntryListenerConfiguration<K, V>>();
        }
    }

    public Class<K> getKeyType() {
        return this.keyType == null ? Object.class : this.keyType;
    }

    public Class<V> getValueType() {
        return this.valueType == null ? Object.class : this.valueType;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return Collections.unmodifiableSet(this.cacheEntryListenerConfigurations);
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.cacheWristerFactory;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public synchronized void addListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.cacheEntryListenerConfigurations.add(cacheEntryListenerConfiguration);
    }

    public synchronized void removeListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.cacheEntryListenerConfigurations.remove(cacheEntryListenerConfiguration);
    }

    public void statisticsEnabled() {
        this.statisticsEnabled = true;
    }

    public void managementEnabled() {
        this.managementEnabled = true;
    }

    public void statisticsDisabled() {
        this.statisticsEnabled = false;
    }

    public void managementDisabled() {
        this.managementEnabled = false;
    }
}

