/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CacheKeyInvocationContextImpl;

@CacheResult
@Interceptor
public class CacheResultInterceptor {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CacheDefaults defaults = this.helper.findDefaults(ic);
        CacheResult cacheResult = ic.getMethod().getAnnotation(CacheResult.class);
        String cacheName = this.helper.defaultName(ic.getMethod(), defaults, cacheResult.cacheName());
        CacheKeyInvocationContextImpl<CacheResult> context = new CacheKeyInvocationContextImpl<CacheResult>(ic, cacheResult, cacheName);
        CacheResolverFactory cacheResolverFactory = this.helper.cacheResolverFactoryFor(defaults, cacheResult.cacheResolverFactory());
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(context);
        Cache cache = cacheResolver.resolveCache(context);
        GeneratedCacheKey cacheKey = this.helper.cacheKeyGeneratorFor(defaults, cacheResult.cacheKeyGenerator()).generateCacheKey(context);
        Cache exceptionCache = null;
        if (!cacheResult.skipGet()) {
            Object exception;
            result = cache.get((Object)cacheKey);
            if (result != null) {
                return result;
            }
            if (!cacheResult.exceptionCacheName().isEmpty() && (exception = (exceptionCache = cacheResolverFactory.getExceptionCacheResolver(context).resolveCache(context)).get((Object)cacheKey)) != null) {
                throw (Throwable)Throwable.class.cast(exception);
            }
        }
        try {
            result = ic.proceed();
            if (result != null) {
                cache.put((Object)cacheKey, result);
            }
            return result;
        }
        catch (Throwable t) {
            if (this.helper.isIncluded(t.getClass(), cacheResult.cachedExceptions(), cacheResult.nonCachedExceptions())) {
                if (exceptionCache == null) {
                    exceptionCache = cacheResolverFactory.getExceptionCacheResolver(context).resolveCache(context);
                }
                exceptionCache.put((Object)cacheKey, (Object)t);
            }
            throw t;
        }
    }
}

