/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;

public class SofnSegment
extends Segment {
    private static final Logger LOGGER = Logger.getLogger(SofnSegment.class.getName());
    public final int width;
    public final int height;
    public final int numberOfComponents;
    public final int precision;
    private final Component[] components;

    public SofnSegment(int marker, byte[] segmentData) throws IOException, ImagingException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public SofnSegment(int marker, int markerLength, InputStream is) throws IOException, ImagingException {
        super(marker, markerLength);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("SOF0Segment markerLength: " + markerLength);
        }
        this.precision = BinaryFunctions.readByte("precision", is, "Not a Valid JPEG File");
        this.height = BinaryFunctions.read2Bytes("height", is, "Not a Valid JPEG File", this.getByteOrder());
        this.width = BinaryFunctions.read2Bytes("width", is, "Not a Valid JPEG File", this.getByteOrder());
        this.numberOfComponents = BinaryFunctions.readByte("numberOfComponents", is, "Not a Valid JPEG File");
        if (this.numberOfComponents < 0) {
            throw new ImagingException("The number of components in a SOF0Segment cannot be less than 0!");
        }
        this.components = (Component[])Allocator.array(this.numberOfComponents, Component[]::new, 32);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            byte componentIdentifier = BinaryFunctions.readByte("ComponentIdentifier", is, "Not a Valid JPEG File");
            byte hvSamplingFactors = BinaryFunctions.readByte("SamplingFactors", is, "Not a Valid JPEG File");
            int horizontalSamplingFactor = hvSamplingFactors >> 4 & 0xF;
            int verticalSamplingFactor = hvSamplingFactors & 0xF;
            byte quantTabDestSelector = BinaryFunctions.readByte("QuantTabDestSel", is, "Not a Valid JPEG File");
            this.components[i] = new Component(componentIdentifier, horizontalSamplingFactor, verticalSamplingFactor, quantTabDestSelector);
        }
    }

    public Component[] getComponents() {
        return (Component[])this.components.clone();
    }

    public Component getComponents(int index) {
        return this.components[index];
    }

    @Override
    public String getDescription() {
        return "SOFN (SOF" + (this.marker - 65472) + ") (" + this.getSegmentType() + ")";
    }

    public static class Component {
        static final int SHALLOW_SIZE = 32;
        public final int componentIdentifier;
        public final int horizontalSamplingFactor;
        public final int verticalSamplingFactor;
        public final int quantTabDestSelector;

        public Component(int componentIdentifier, int horizontalSamplingFactor, int veritcalSamplingFactor, int quantTabDestSelector) {
            this.componentIdentifier = componentIdentifier;
            this.horizontalSamplingFactor = horizontalSamplingFactor;
            this.verticalSamplingFactor = veritcalSamplingFactor;
            this.quantTabDestSelector = quantTabDestSelector;
        }
    }
}

