/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterYCbCr
extends PhotometricInterpreter {
    public static int convertYCbCrtoRGB(int y, int cb, int cr) {
        double r1 = 1.164 * ((double)y - 16.0) + 1.596 * ((double)cr - 128.0);
        double g1 = 1.164 * ((double)y - 16.0) - 0.813 * ((double)cr - 128.0) - 0.392 * ((double)cb - 128.0);
        double b1 = 1.164 * ((double)y - 16.0) + 2.017 * ((double)cb - 128.0);
        int r = PhotometricInterpreterYCbCr.limit((int)r1, 0, 255);
        int g = PhotometricInterpreterYCbCr.limit((int)g1, 0, 255);
        int b = PhotometricInterpreterYCbCr.limit((int)b1, 0, 255);
        int alpha = 255;
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static int limit(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    public PhotometricInterpreterYCbCr(int samplesPerPixel, int[] bitsPerSample, int predictor, int width, int height) {
        super(samplesPerPixel, bitsPerSample, predictor, width, height);
    }

    @Override
    public void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImagingException, IOException {
        int Y = samples[0];
        int cb = samples[1];
        int cr = samples[2];
        double r = (double)Y + 1.402 * ((double)cr - 128.0);
        double g = (double)Y - 0.34414 * ((double)cb - 128.0) - 0.71414 * ((double)cr - 128.0);
        double b = (double)Y + 1.772 * ((double)cb - 128.0);
        int red = PhotometricInterpreterYCbCr.limit((int)r, 0, 255);
        int green = PhotometricInterpreterYCbCr.limit((int)g, 0, 255);
        int blue = PhotometricInterpreterYCbCr.limit((int)b, 0, 255);
        int alpha = 255;
        int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
        imageBuilder.setRGB(x, y, rgb);
    }
}

