/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterLogLuv
extends PhotometricInterpreter {
    public PhotometricInterpreterLogLuv(int samplesPerPixel, int[] bitsPerSample, int predictor, int width, int height) {
        super(samplesPerPixel, bitsPerSample, predictor, width, height);
    }

    RgbValues getRgbValues(TristimulusValues tristimulusValues) {
        float varX = tristimulusValues.x / 100.0f;
        float varY = tristimulusValues.y / 100.0f;
        float varZ = tristimulusValues.z / 100.0f;
        float varR = varX * 3.2406f + varY * -1.5372f + varZ * -0.4986f;
        float varG = varX * -0.9689f + varY * 1.8758f + varZ * 0.0415f;
        float varB = varX * 0.0557f + varY * -0.204f + varZ * 1.057f;
        varR = (double)varR > 0.0031308 ? 1.055f * (float)Math.pow(varR, 0.4166666666666667) - 0.055f : 12.92f * varR;
        varG = (double)varG > 0.0031308 ? 1.055f * (float)Math.pow(varG, 0.4166666666666667) - 0.055f : 12.92f * varG;
        varB = (double)varB > 0.0031308 ? 1.055f * (float)Math.pow(varB, 0.4166666666666667) - 0.055f : 12.92f * varB;
        RgbValues values = new RgbValues();
        values.r = (int)(varR * 255.0f);
        values.g = (int)(varG * 255.0f);
        values.b = (int)(varB * 255.0f);
        return values;
    }

    TristimulusValues getTristimulusValues(int cieL, int cieA, int cieB) {
        float varY = ((float)cieL * 100.0f / 255.0f + 16.0f) / 116.0f;
        float varX = (float)cieA / 500.0f + varY;
        float varZ = varY - (float)cieB / 200.0f;
        float varXCube = (float)Math.pow(varX, 3.0);
        float varYCube = (float)Math.pow(varY, 3.0);
        float varZCube = (float)Math.pow(varZ, 3.0);
        varY = varYCube > 0.008856f ? varYCube : (varY - 0.13793103f) / 7.787f;
        varX = varXCube > 0.008856f ? varXCube : (varX - 0.13793103f) / 7.787f;
        varZ = varZCube > 0.008856f ? varZCube : (varZ - 0.13793103f) / 7.787f;
        float refX = 95.047f;
        float refY = 100.0f;
        float refZ = 108.883f;
        TristimulusValues values = new TristimulusValues();
        values.x = 95.047f * varX;
        values.y = 100.0f * varY;
        values.z = 108.883f * varZ;
        return values;
    }

    @Override
    public void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImagingException, IOException {
        if (samples == null || samples.length != 3) {
            throw new ImagingException("Invalid length of bits per sample (expected 3).");
        }
        int cieL = samples[0];
        byte cieA = (byte)samples[1];
        byte cieB = (byte)samples[2];
        TristimulusValues tristimulusValues = this.getTristimulusValues(cieL, cieA, cieB);
        RgbValues rgbValues = this.getRgbValues(tristimulusValues);
        int red = Math.min(255, Math.max(0, rgbValues.r));
        int green = Math.min(255, Math.max(0, rgbValues.g));
        int blue = Math.min(255, Math.max(0, rgbValues.b));
        int alpha = 255;
        int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
        imageBuilder.setRGB(x, y, rgb);
    }

    static class TristimulusValues {
        public float x;
        public float y;
        public float z;

        TristimulusValues() {
        }
    }

    static class RgbValues {
        public int r;
        public int g;
        public int b;

        RgbValues() {
        }
    }
}

