/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.imaging.ImagingConstants;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBlock;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcParser;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegRewriter;

public class JpegIptcRewriter
extends JpegRewriter {
    public void removeIPTC(byte[] src, OutputStream os) throws ImagingException, IOException, ImagingException {
        this.removeIPTC(src, os, false);
    }

    public void removeIPTC(byte[] src, OutputStream os, boolean removeSegment) throws ImagingException, IOException, ImagingException {
        ByteSource byteSource = ByteSource.array(src);
        this.removeIPTC(byteSource, os, removeSegment);
    }

    public void removeIPTC(ByteSource byteSource, OutputStream os) throws ImagingException, IOException, ImagingException {
        this.removeIPTC(byteSource, os, false);
    }

    public void removeIPTC(ByteSource byteSource, OutputStream os, boolean removeSegment) throws ImagingException, IOException, ImagingException {
        JpegRewriter.JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List<JpegRewriter.JFIFPiece> oldPieces = jfifPieces.pieces;
        List<JpegRewriter.JFIFPiece> photoshopApp13Segments = this.findPhotoshopApp13Segments(oldPieces);
        if (photoshopApp13Segments.size() > 1) {
            throw new ImagingException("Image contains more than one Photoshop App13 segment.");
        }
        List<JpegRewriter.JFIFPiece> newPieces = this.removePhotoshopApp13Segments(oldPieces);
        if (!removeSegment && photoshopApp13Segments.size() == 1) {
            JpegRewriter.JFIFPieceSegment oldSegment = (JpegRewriter.JFIFPieceSegment)photoshopApp13Segments.get(0);
            JpegImagingParameters params = new JpegImagingParameters();
            PhotoshopApp13Data oldData = new IptcParser().parsePhotoshopSegment(oldSegment.getSegmentData(), params);
            List<IptcBlock> newBlocks = oldData.getNonIptcBlocks();
            ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
            PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
            byte[] segmentBytes = new IptcParser().writePhotoshopApp13Segment(newData);
            JpegRewriter.JFIFPieceSegment newSegment = new JpegRewriter.JFIFPieceSegment(oldSegment.marker, segmentBytes);
            newPieces.add(oldPieces.indexOf(oldSegment), newSegment);
        }
        this.writeSegments(os, newPieces);
    }

    public void removeIPTC(File src, OutputStream os) throws ImagingException, IOException, ImagingException {
        this.removeIPTC(src, os, false);
    }

    public void removeIPTC(File src, OutputStream os, boolean removeSegment) throws ImagingException, IOException, ImagingException {
        ByteSource byteSource = ByteSource.file(src);
        this.removeIPTC(byteSource, os, removeSegment);
    }

    public void removeIPTC(InputStream src, OutputStream os) throws ImagingException, IOException, ImagingException {
        this.removeIPTC(src, os, false);
    }

    public void removeIPTC(InputStream src, OutputStream os, boolean removeSegment) throws ImagingException, IOException, ImagingException {
        ByteSource byteSource = ByteSource.inputStream(src, null);
        this.removeIPTC(byteSource, os, removeSegment);
    }

    public void writeIPTC(byte[] src, OutputStream os, PhotoshopApp13Data newData) throws ImagingException, IOException, ImagingException {
        ByteSource byteSource = ByteSource.array(src);
        this.writeIPTC(byteSource, os, newData);
    }

    public void writeIPTC(ByteSource byteSource, OutputStream os, PhotoshopApp13Data newData) throws ImagingException, IOException, ImagingException {
        JpegRewriter.JFIFPieces jfifPieces = this.analyzeJFIF(byteSource);
        List<JpegRewriter.JFIFPiece> oldPieces = jfifPieces.pieces;
        List<JpegRewriter.JFIFPiece> photoshopApp13Segments = this.findPhotoshopApp13Segments(oldPieces);
        if (photoshopApp13Segments.size() > 1) {
            throw new ImagingException("Image contains more than one Photoshop App13 segment.");
        }
        List<JpegRewriter.JFIFPiece> newPieces = this.removePhotoshopApp13Segments(oldPieces);
        List<IptcBlock> newBlocks = newData.getNonIptcBlocks();
        byte[] newBlockBytes = new IptcParser().writeIPTCBlock(newData.getRecords());
        int blockType = 1028;
        byte[] blockNameBytes = ImagingConstants.EMPTY_BYTE_ARRAY;
        IptcBlock newBlock = new IptcBlock(1028, blockNameBytes, newBlockBytes);
        newBlocks.add(newBlock);
        newData = new PhotoshopApp13Data(newData.getRecords(), newBlocks);
        byte[] segmentBytes = new IptcParser().writePhotoshopApp13Segment(newData);
        JpegRewriter.JFIFPieceSegment newSegment = new JpegRewriter.JFIFPieceSegment(65517, segmentBytes);
        newPieces = this.insertAfterLastAppSegments(newPieces, Arrays.asList(newSegment));
        this.writeSegments(os, newPieces);
    }

    public void writeIPTC(File src, OutputStream os, PhotoshopApp13Data newData) throws ImagingException, IOException, ImagingException {
        ByteSource byteSource = ByteSource.file(src);
        this.writeIPTC(byteSource, os, newData);
    }

    public void writeIPTC(InputStream src, OutputStream os, PhotoshopApp13Data newData) throws ImagingException, IOException, ImagingException {
        ByteSource byteSource = ByteSource.inputStream(src, null);
        this.writeIPTC(byteSource, os, newData);
    }
}

