/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.XmpEmbeddable;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.decoder.JpegDecoder;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcParser;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.formats.jpeg.segments.App13Segment;
import org.apache.commons.imaging.formats.jpeg.segments.App14Segment;
import org.apache.commons.imaging.formats.jpeg.segments.App2Segment;
import org.apache.commons.imaging.formats.jpeg.segments.ComSegment;
import org.apache.commons.imaging.formats.jpeg.segments.DqtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.GenericSegment;
import org.apache.commons.imaging.formats.jpeg.segments.JfifSegment;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;
import org.apache.commons.imaging.formats.jpeg.segments.SofnSegment;
import org.apache.commons.imaging.formats.jpeg.segments.UnknownSegment;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpParser;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.internal.Debug;

public class JpegImageParser
extends ImageParser<JpegImagingParameters>
implements XmpEmbeddable<JpegImagingParameters> {
    private static final Logger LOGGER = Logger.getLogger(JpegImageParser.class.getName());
    private static final String DEFAULT_EXTENSION = ImageFormats.JPEG.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.JPEG.getExtensions();

    public static boolean isExifAPP1Segment(GenericSegment segment) {
        return BinaryFunctions.startsWith(segment.getSegmentData(), JpegConstants.EXIF_IDENTIFIER_CODE);
    }

    private byte[] assembleSegments(List<App2Segment> segments) throws ImagingException {
        try {
            return this.assembleSegments(segments, false);
        }
        catch (ImagingException e) {
            return this.assembleSegments(segments, true);
        }
    }

    private byte[] assembleSegments(List<App2Segment> segments, boolean startWithZero) throws ImagingException {
        if (segments.isEmpty()) {
            throw new ImagingException("No App2 Segments Found.");
        }
        int markerCount = segments.get((int)0).numMarkers;
        if (segments.size() != markerCount) {
            throw new ImagingException("App2 Segments Missing.  Found: " + segments.size() + ", Expected: " + markerCount + ".");
        }
        segments.sort(null);
        int offset = startWithZero ? 0 : 1;
        int total = 0;
        for (int i = 0; i < segments.size(); ++i) {
            App2Segment segment = segments.get(i);
            if (i + offset != segment.curMarker) {
                this.dumpSegments(segments);
                throw new ImagingException("Incoherent App2 Segment Ordering.  i: " + i + ", segment[" + i + "].curMarker: " + segment.curMarker + ".");
            }
            if (markerCount != segment.numMarkers) {
                this.dumpSegments(segments);
                throw new ImagingException("Inconsistent App2 Segment Count info.  markerCount: " + markerCount + ", segment[" + i + "].numMarkers: " + segment.numMarkers + ".");
            }
            if (segment.getIccBytes() == null) continue;
            total += segment.getIccBytes().length;
        }
        byte[] result = Allocator.byteArray(total);
        int progress = 0;
        for (App2Segment segment : segments) {
            System.arraycopy(segment.getIccBytes(), 0, result, progress, segment.getIccBytes().length);
            progress += segment.getIccBytes().length;
        }
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        pw.println("jpeg.dumpImageFile");
        ImageInfo imageInfo = this.getImageInfo(byteSource);
        if (imageInfo == null) {
            return false;
        }
        imageInfo.toString(pw, "");
        pw.println("");
        List<Segment> segments = this.readSegments(byteSource, null, false);
        if (segments == null) {
            throw new ImagingException("No Segments Found.");
        }
        for (int d = 0; d < segments.size(); ++d) {
            Segment segment = segments.get(d);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            pw.println(d + ": marker: " + Integer.toHexString(segment.marker) + ", " + segment.getDescription() + " (length: " + nf.format(segment.length) + ")");
            segment.dump(pw);
        }
        pw.println("");
        return true;
    }

    private void dumpSegments(List<? extends Segment> v) {
        Debug.debug();
        Debug.debug("dumpSegments: " + v.size());
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = (App2Segment)v.get(i);
            Debug.debug(i + ": " + segment.curMarker + " / " + segment.numMarkers);
        }
        Debug.debug();
    }

    private List<Segment> filterAPP1Segments(List<Segment> segments) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        for (Segment s : segments) {
            GenericSegment segment = (GenericSegment)s;
            if (!JpegImageParser.isExifAPP1Segment(segment)) continue;
            result.add(segment);
        }
        return result;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.JPEG};
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, JpegImagingParameters params) throws ImagingException, IOException {
        JpegDecoder jpegDecoder = new JpegDecoder();
        return jpegDecoder.decode(byteSource);
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    public JpegImagingParameters getDefaultParameters() {
        return new JpegImagingParameters();
    }

    public TiffImageMetadata getExifMetadata(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        byte[] bytes = this.getExifRawData(byteSource);
        if (null == bytes) {
            return null;
        }
        if (params == null) {
            params = new TiffImagingParameters();
        }
        params.setReadThumbnails(Boolean.TRUE);
        return (TiffImageMetadata)new TiffImageParser().getMetadata(bytes, params);
    }

    public byte[] getExifRawData(ByteSource byteSource) throws ImagingException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65505}, false);
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        List<Segment> exifSegments = this.filterAPP1Segments(segments);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("exifSegments.size(): " + exifSegments.size());
        }
        if (exifSegments.isEmpty()) {
            return null;
        }
        if (exifSegments.size() > 1) {
            throw new ImagingException("Imaging currently can't parse EXIF metadata split across multiple APP1 segments.  Please send this image to the Imaging project.");
        }
        GenericSegment segment = (GenericSegment)exifSegments.get(0);
        byte[] bytes = segment.getSegmentData();
        return BinaryFunctions.remainingBytes("trimmed exif bytes", bytes, 6);
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, JpegImagingParameters params) throws ImagingException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65506}, false);
        ArrayList<App2Segment> filtered = new ArrayList<App2Segment>();
        if (segments != null) {
            for (Segment s : segments) {
                App2Segment segment = (App2Segment)s;
                if (segment.getIccBytes() == null) continue;
                filtered.add(segment);
            }
        }
        if (filtered.isEmpty()) {
            return null;
        }
        byte[] bytes = this.assembleSegments(filtered);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("bytes: " + bytes.length);
        }
        return bytes;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, JpegImagingParameters params) throws ImagingException, IOException {
        String formatDetails;
        List<Segment> SOF_segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, false);
        if (SOF_segments == null) {
            throw new ImagingException("No SOFN Data Found.");
        }
        List<Segment> jfifSegments = this.readSegments(byteSource, new int[]{65504}, true);
        SofnSegment fSOFNSegment = (SofnSegment)SOF_segments.get(0);
        if (fSOFNSegment == null) {
            throw new ImagingException("No SOFN Data Found.");
        }
        int width = fSOFNSegment.width;
        int height = fSOFNSegment.height;
        JfifSegment jfifSegment = null;
        if (jfifSegments != null && !jfifSegments.isEmpty()) {
            jfifSegment = (JfifSegment)jfifSegments.get(0);
        }
        List<Segment> app14Segments = this.readSegments(byteSource, new int[]{65518}, true);
        App14Segment app14Segment = null;
        if (app14Segments != null && !app14Segments.isEmpty()) {
            app14Segment = (App14Segment)app14Segments.get(0);
        }
        double xDensity = -1.0;
        double yDensity = -1.0;
        double unitsPerInch = -1.0;
        if (jfifSegment != null) {
            xDensity = jfifSegment.xDensity;
            yDensity = jfifSegment.yDensity;
            int densityUnits = jfifSegment.densityUnits;
            formatDetails = "Jpeg/JFIF v." + jfifSegment.jfifMajorVersion + "." + jfifSegment.jfifMinorVersion;
            switch (densityUnits) {
                case 0: {
                    break;
                }
                case 1: {
                    unitsPerInch = 1.0;
                    break;
                }
                case 2: {
                    unitsPerInch = 2.54;
                    break;
                }
            }
        } else {
            JpegImageMetadata metadata = (JpegImageMetadata)this.getMetadata(byteSource, params);
            if (metadata != null) {
                TiffField field = metadata.findEXIFValue(TiffTagConstants.TIFF_TAG_XRESOLUTION);
                if (field != null) {
                    xDensity = ((Number)field.getValue()).doubleValue();
                }
                if ((field = metadata.findEXIFValue(TiffTagConstants.TIFF_TAG_YRESOLUTION)) != null) {
                    yDensity = ((Number)field.getValue()).doubleValue();
                }
                if ((field = metadata.findEXIFValue(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT)) != null) {
                    int densityUnits = ((Number)field.getValue()).intValue();
                    switch (densityUnits) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            unitsPerInch = 1.0;
                            break;
                        }
                        case 3: {
                            unitsPerInch = 2.54;
                            break;
                        }
                    }
                }
            }
            formatDetails = "Jpeg/DCM";
        }
        int physicalHeightDpi = -1;
        float physicalHeightInch = -1.0f;
        int physicalWidthDpi = -1;
        float physicalWidthInch = -1.0f;
        if (unitsPerInch > 0.0) {
            physicalWidthDpi = (int)Math.round(xDensity * unitsPerInch);
            physicalWidthInch = (float)((double)width / (xDensity * unitsPerInch));
            physicalHeightDpi = (int)Math.round(yDensity * unitsPerInch);
            physicalHeightInch = (float)((double)height / (yDensity * unitsPerInch));
        }
        List<Segment> commentSegments = this.readSegments(byteSource, new int[]{65534}, false);
        ArrayList<String> comments = Allocator.arrayList(commentSegments.size());
        for (Segment commentSegment : commentSegments) {
            ComSegment comSegment = (ComSegment)commentSegment;
            comments.add(new String(comSegment.getComment(), StandardCharsets.UTF_8));
        }
        int numberOfComponents = fSOFNSegment.numberOfComponents;
        int precision = fSOFNSegment.precision;
        int bitsPerPixel = numberOfComponents * precision;
        ImageFormats format = ImageFormats.JPEG;
        String formatName = "JPEG (Joint Photographic Experts Group) Format";
        String mimeType = "image/jpeg";
        boolean numberOfImages = true;
        boolean progressive = fSOFNSegment.marker == 65474;
        boolean transparent = false;
        boolean usesPalette = false;
        ImageInfo.ColorType colorType = ImageInfo.ColorType.UNKNOWN;
        if (app14Segment != null && app14Segment.isAdobeJpegSegment()) {
            int colorTransform = app14Segment.getAdobeColorTransform();
            switch (colorTransform) {
                case 0: {
                    if (numberOfComponents == 3) {
                        colorType = ImageInfo.ColorType.RGB;
                        break;
                    }
                    if (numberOfComponents != 4) break;
                    colorType = ImageInfo.ColorType.CMYK;
                    break;
                }
                case 1: {
                    colorType = ImageInfo.ColorType.YCbCr;
                    break;
                }
                case 2: {
                    colorType = ImageInfo.ColorType.YCCK;
                    break;
                }
            }
        } else if (jfifSegment != null) {
            if (numberOfComponents == 1) {
                colorType = ImageInfo.ColorType.GRAYSCALE;
            } else if (numberOfComponents == 3) {
                colorType = ImageInfo.ColorType.YCbCr;
            }
        } else {
            switch (numberOfComponents) {
                case 1: {
                    colorType = ImageInfo.ColorType.GRAYSCALE;
                    break;
                }
                case 2: {
                    colorType = ImageInfo.ColorType.GRAYSCALE;
                    transparent = true;
                    break;
                }
                case 3: 
                case 4: {
                    boolean isSubsampled;
                    boolean have1 = false;
                    boolean have2 = false;
                    boolean have3 = false;
                    boolean have4 = false;
                    boolean haveOther = false;
                    block36: for (SofnSegment.Component component : fSOFNSegment.getComponents()) {
                        int id = component.componentIdentifier;
                        switch (id) {
                            case 1: {
                                have1 = true;
                                continue block36;
                            }
                            case 2: {
                                have2 = true;
                                continue block36;
                            }
                            case 3: {
                                have3 = true;
                                continue block36;
                            }
                            case 4: {
                                have4 = true;
                                continue block36;
                            }
                            default: {
                                haveOther = true;
                            }
                        }
                    }
                    if (numberOfComponents == 3 && have1 && have2 && have3 && !have4 && !haveOther) {
                        colorType = ImageInfo.ColorType.YCbCr;
                        break;
                    }
                    if (numberOfComponents == 4 && have1 && have2 && have3 && have4 && !haveOther) {
                        colorType = ImageInfo.ColorType.YCbCr;
                        transparent = true;
                        break;
                    }
                    boolean haveR = false;
                    boolean haveG = false;
                    boolean haveB = false;
                    boolean haveA = false;
                    boolean haveC = false;
                    boolean havec = false;
                    boolean haveY = false;
                    block37: for (SofnSegment.Component component : fSOFNSegment.getComponents()) {
                        int id = component.componentIdentifier;
                        switch (id) {
                            case 82: {
                                haveR = true;
                                continue block37;
                            }
                            case 71: {
                                haveG = true;
                                continue block37;
                            }
                            case 66: {
                                haveB = true;
                                continue block37;
                            }
                            case 65: {
                                haveA = true;
                                continue block37;
                            }
                            case 67: {
                                haveC = true;
                                continue block37;
                            }
                            case 99: {
                                havec = true;
                                continue block37;
                            }
                            case 89: {
                                haveY = true;
                                continue block37;
                            }
                        }
                    }
                    if (haveR && haveG && haveB && !haveA && !haveC && !havec && !haveY) {
                        colorType = ImageInfo.ColorType.RGB;
                        break;
                    }
                    if (haveR && haveG && haveB && haveA && !haveC && !havec && !haveY) {
                        colorType = ImageInfo.ColorType.RGB;
                        transparent = true;
                        break;
                    }
                    if (haveY && haveC && havec && !haveR && !haveG && !haveB && !haveA) {
                        colorType = ImageInfo.ColorType.YCC;
                        break;
                    }
                    if (haveY && haveC && havec && haveA && !haveR && !haveG && !haveB) {
                        colorType = ImageInfo.ColorType.YCC;
                        transparent = true;
                        break;
                    }
                    int minHorizontalSamplingFactor = Integer.MAX_VALUE;
                    int maxHorizontalSmaplingFactor = Integer.MIN_VALUE;
                    int minVerticalSamplingFactor = Integer.MAX_VALUE;
                    int maxVerticalSamplingFactor = Integer.MIN_VALUE;
                    for (SofnSegment.Component component : fSOFNSegment.getComponents()) {
                        if (minHorizontalSamplingFactor > component.horizontalSamplingFactor) {
                            minHorizontalSamplingFactor = component.horizontalSamplingFactor;
                        }
                        if (maxHorizontalSmaplingFactor < component.horizontalSamplingFactor) {
                            maxHorizontalSmaplingFactor = component.horizontalSamplingFactor;
                        }
                        if (minVerticalSamplingFactor > component.verticalSamplingFactor) {
                            minVerticalSamplingFactor = component.verticalSamplingFactor;
                        }
                        if (maxVerticalSamplingFactor >= component.verticalSamplingFactor) continue;
                        maxVerticalSamplingFactor = component.verticalSamplingFactor;
                    }
                    boolean bl = isSubsampled = minHorizontalSamplingFactor != maxHorizontalSmaplingFactor || minVerticalSamplingFactor != maxVerticalSamplingFactor;
                    if (numberOfComponents == 3) {
                        if (isSubsampled) {
                            colorType = ImageInfo.ColorType.YCbCr;
                            break;
                        }
                        colorType = ImageInfo.ColorType.RGB;
                        break;
                    }
                    if (numberOfComponents != 4) break;
                    if (isSubsampled) {
                        colorType = ImageInfo.ColorType.YCCK;
                        break;
                    }
                    colorType = ImageInfo.ColorType.CMYK;
                    break;
                }
            }
        }
        ImageInfo.CompressionAlgorithm compressionAlgorithm = ImageInfo.CompressionAlgorithm.JPEG;
        return new ImageInfo(formatDetails, bitsPerPixel, comments, format, "JPEG (Joint Photographic Experts Group) Format", height, "image/jpeg", 1, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, progressive, transparent, false, colorType, compressionAlgorithm);
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, JpegImagingParameters params) throws ImagingException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, true);
        if (segments == null || segments.isEmpty()) {
            throw new ImagingException("No JFIF Data Found.");
        }
        if (segments.size() > 1) {
            throw new ImagingException("Redundant JFIF Data Found.");
        }
        SofnSegment fSOFNSegment = (SofnSegment)segments.get(0);
        return new Dimension(fSOFNSegment.width, fSOFNSegment.height);
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, JpegImagingParameters params) throws ImagingException, IOException {
        if (params == null) {
            params = new JpegImagingParameters();
        }
        TiffImageMetadata exif = this.getExifMetadata(byteSource, new TiffImagingParameters());
        JpegPhotoshopMetadata photoshop = this.getPhotoshopMetadata(byteSource, params);
        if (null == exif && null == photoshop) {
            return null;
        }
        return new JpegImageMetadata(photoshop, exif);
    }

    @Override
    public String getName() {
        return "Jpeg-Custom";
    }

    public JpegPhotoshopMetadata getPhotoshopMetadata(ByteSource byteSource, JpegImagingParameters params) throws ImagingException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65517}, false);
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        PhotoshopApp13Data photoshopApp13Data = null;
        for (Segment s : segments) {
            App13Segment segment = (App13Segment)s;
            PhotoshopApp13Data data = segment.parsePhotoshopSegment(params);
            if (data == null) continue;
            if (photoshopApp13Data != null) {
                throw new ImagingException("JPEG contains more than one Photoshop App13 segment.");
            }
            photoshopApp13Data = data;
        }
        if (null == photoshopApp13Data) {
            return null;
        }
        return new JpegPhotoshopMetadata(photoshopApp13Data);
    }

    @Override
    public String getXmpXml(ByteSource byteSource, XmpImagingParameters<JpegImagingParameters> params) throws ImagingException, IOException {
        final ArrayList result = new ArrayList();
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImagingException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && new JpegXmpParser().isXmpJpegSegment(segmentData)) {
                    result.add(new JpegXmpParser().parseXmpJpegSegment(segmentData));
                    return false;
                }
                return true;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new ImagingException("JPEG file contains more than one XMP segment.");
        }
        return (String)result.get(0);
    }

    public boolean hasExifSegment(ByteSource byteSource) throws ImagingException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && BinaryFunctions.startsWith(segmentData, JpegConstants.EXIF_IDENTIFIER_CODE)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    public boolean hasIptcSegment(ByteSource byteSource) throws ImagingException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65517 && new IptcParser().isPhotoshopJpegSegment(segmentData)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    public boolean hasXmpSegment(ByteSource byteSource) throws ImagingException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && new JpegXmpParser().isXmpJpegSegment(segmentData)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    private boolean keepMarker(int marker, int[] markers) {
        if (markers == null) {
            return true;
        }
        for (int marker2 : markers) {
            if (marker2 != marker) continue;
            return true;
        }
        return false;
    }

    public List<Segment> readSegments(ByteSource byteSource, final int[] markers, final boolean returnAfterFirst) throws ImagingException, IOException {
        final ArrayList<Segment> result = new ArrayList<Segment>();
        final int[] sofnSegments = new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImagingException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (!JpegImageParser.this.keepMarker(marker, markers)) {
                    return true;
                }
                switch (marker) {
                    case 65517: {
                        result.add(new App13Segment(marker, segmentData));
                        break;
                    }
                    case 65518: {
                        result.add(new App14Segment(marker, segmentData));
                        break;
                    }
                    case 65506: {
                        result.add(new App2Segment(marker, segmentData));
                        break;
                    }
                    case 65504: {
                        result.add(new JfifSegment(marker, segmentData));
                        break;
                    }
                    default: {
                        if (Arrays.binarySearch(sofnSegments, marker) >= 0) {
                            result.add(new SofnSegment(marker, segmentData));
                            break;
                        }
                        if (marker == 65499) {
                            result.add(new DqtSegment(marker, segmentData));
                            break;
                        }
                        if (marker >= 65505 && marker <= 65519) {
                            result.add(new UnknownSegment(marker, segmentData));
                            break;
                        }
                        if (marker != 65534) break;
                        result.add(new ComSegment(marker, segmentData));
                    }
                }
                return !returnAfterFirst;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result;
    }
}

