/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryConstant;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFiles;

public final class BinaryFunctions {
    private static final Logger LOGGER = Logger.getLogger(BinaryFunctions.class.getName());

    public static int charsToQuad(char c1, char c2, char c3, char c4) {
        return (0xFF & c1) << 24 | (0xFF & c2) << 16 | (0xFF & c3) << 8 | (0xFF & c4) << 0;
    }

    public static boolean compareBytes(byte[] a, int aStart, byte[] b, int bStart, int length) {
        if (a.length < aStart + length) {
            return false;
        }
        if (b.length < bStart + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aStart + i] == b[bStart + i]) continue;
            return false;
        }
        return true;
    }

    public static int findNull(byte[] src, int start, String message) throws ImagingException {
        for (int i = start; i < src.length; ++i) {
            if (src[i] != 0) continue;
            return i;
        }
        throw new ImagingException(message);
    }

    public static int findNull(byte[] src, String message) throws ImagingException {
        return BinaryFunctions.findNull(src, 0, message);
    }

    public static byte[] getRAFBytes(RandomAccessFile raf, long pos, int length, String exception) throws IOException {
        if (length < 0) {
            throw new IOException(String.format("%s, invalid length: %d", exception, length));
        }
        Allocator.checkByteArray(length);
        return RandomAccessFiles.read((RandomAccessFile)raf, (long)pos, (int)length);
    }

    public static byte[] head(byte[] bytes, int count) {
        if (count > bytes.length) {
            count = bytes.length;
        }
        return BinaryFunctions.slice(bytes, 0, count);
    }

    public static void logByteBits(String msg, byte i) {
        LOGGER.finest(msg + ": '" + Integer.toBinaryString(0xFF & i));
    }

    public static void logCharQuad(String msg, int i) {
        LOGGER.finest(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    public static void printCharQuad(PrintWriter pw, String msg, int i) {
        pw.println(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    public static byte[] quadsToByteArray(int quad) {
        byte[] arr = new byte[]{(byte)(quad >> 24), (byte)(quad >> 16), (byte)(quad >> 8), (byte)quad};
        return arr;
    }

    public static int read2Bytes(String name, InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read())) < 0) {
            throw new IOException(exception);
        }
        int result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 8 | byte1 : byte1 << 8 | byte0;
        return result;
    }

    public static int read3Bytes(String name, InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        int byte2;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read()) | (byte2 = is.read())) < 0) {
            throw new IOException(exception);
        }
        int result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 16 | byte1 << 8 | byte2 << 0 : byte2 << 16 | byte1 << 8 | byte0 << 0;
        return result;
    }

    public static int read4Bytes(String name, InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        int byte3;
        int byte2;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read()) | (byte2 = is.read()) | (byte3 = is.read())) < 0) {
            throw new IOException(exception);
        }
        int result = byteOrder == ByteOrder.BIG_ENDIAN ? byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3 << 0 : byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0 << 0;
        return result;
    }

    public static void readAndVerifyBytes(InputStream is, BinaryConstant expected, String exception) throws ImagingException, IOException {
        for (int i = 0; i < expected.size(); ++i) {
            int data = is.read();
            byte b = (byte)(0xFF & data);
            if (data < 0) {
                throw new ImagingException("Unexpected EOF.");
            }
            if (b == expected.get(i)) continue;
            throw new ImagingException(exception);
        }
    }

    public static void readAndVerifyBytes(InputStream is, byte[] expected, String exception) throws ImagingException, IOException {
        for (byte element : expected) {
            int data = is.read();
            byte b = (byte)(0xFF & data);
            if (data < 0) {
                throw new ImagingException("Unexpected EOF.");
            }
            if (b == element) continue;
            throw new ImagingException(exception);
        }
    }

    public static byte readByte(String name, InputStream is, String exceptionMessage) throws IOException {
        int result = is.read();
        if (result < 0) {
            throw new IOException(exceptionMessage);
        }
        return (byte)(0xFF & result);
    }

    public static byte[] readBytes(InputStream is, int count) throws IOException {
        return BinaryFunctions.readBytes("", is, count, "Unexpected EOF");
    }

    public static byte[] readBytes(String name, InputStream is, int length) throws IOException {
        return BinaryFunctions.readBytes(name, is, length, name + " could not be read.");
    }

    public static byte[] readBytes(String name, InputStream is, int length, String exception) throws IOException {
        try {
            return IOUtils.toByteArray((InputStream)is, (int)Allocator.check(length));
        }
        catch (IOException e) {
            throw new IOException(exception + ", name: " + name + ", length: " + length);
        }
    }

    public static byte[] remainingBytes(String name, byte[] bytes, int count) {
        return BinaryFunctions.slice(bytes, count, bytes.length - count);
    }

    public static boolean searchQuad(int quad, InputStream bis) throws IOException {
        byte[] needle = BinaryFunctions.quadsToByteArray(quad);
        byte b = -1;
        int position = 0;
        while ((b = bis.read()) != -1) {
            if (needle[position] == b) {
                if (++position != needle.length) continue;
                return true;
            }
            position = 0;
        }
        return false;
    }

    public static long skipBytes(InputStream is, long length) throws IOException {
        return BinaryFunctions.skipBytes(is, length, "Couldn't skip bytes");
    }

    public static long skipBytes(InputStream is, long length, String exception) throws IOException {
        try {
            return IOUtils.skip((InputStream)is, (long)length);
        }
        catch (IOException e) {
            throw new IOException(exception, e);
        }
    }

    public static byte[] slice(byte[] bytes, int start, int count) {
        byte[] result = Allocator.byteArray(count);
        System.arraycopy(bytes, start, result, 0, count);
        return result;
    }

    public static boolean startsWith(byte[] buffer, BinaryConstant search) {
        if (buffer == null || buffer.length < search.size()) {
            return false;
        }
        for (int i = 0; i < search.size(); ++i) {
            if (buffer[i] == search.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(byte[] buffer, byte[] search) {
        if (search == null) {
            return false;
        }
        if (buffer == null) {
            return false;
        }
        if (search.length > buffer.length) {
            return false;
        }
        for (int i = 0; i < search.length; ++i) {
            if (search[i] == buffer[i]) continue;
            return false;
        }
        return true;
    }

    private BinaryFunctions() {
    }
}

