/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorHsv {
    public static final ColorHsv BLACK = new ColorHsv(0.0, 0.0, 0.0);
    public static final ColorHsv WHITE = new ColorHsv(0.0, 0.0, 100.0);
    public static final ColorHsv RED = new ColorHsv(0.0, 100.0, 100.0);
    public static final ColorHsv GREEN = new ColorHsv(120.0, 100.0, 100.0);
    public static final ColorHsv BLUE = new ColorHsv(240.0, 100.0, 100.0);
    public final double h;
    public final double s;
    public final double v;

    public ColorHsv(double h, double s, double v) {
        this.h = h;
        this.s = s;
        this.v = v;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorHsv colorHsv = (ColorHsv)o;
        if (Double.compare(colorHsv.h, this.h) != 0) {
            return false;
        }
        if (Double.compare(colorHsv.s, this.s) != 0) {
            return false;
        }
        return Double.compare(colorHsv.v, this.v) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.h);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.s);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.v);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "{H: " + this.h + ", S: " + this.s + ", V: " + this.v + "}";
    }
}

