/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryOutputStream;

abstract class TiffOutputItem {
    public static final long UNDEFINED_VALUE = -1L;
    private long offset = -1L;

    TiffOutputItem() {
    }

    public abstract String getItemDescription();

    public abstract int getItemLength();

    protected long getOffset() {
        return this.offset;
    }

    protected void setOffset(long offset) {
        this.offset = offset;
    }

    public abstract void writeItem(BinaryOutputStream var1) throws IOException, ImagingException;

    public static class Value
    extends TiffOutputItem {
        static final int SHALLOW_SIZE = 32;
        private final byte[] bytes;
        private final String name;

        Value(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        @Override
        public String getItemDescription() {
            return this.name;
        }

        @Override
        public int getItemLength() {
            return this.bytes.length;
        }

        public void updateValue(byte[] bytes) throws ImagingException {
            if (this.bytes.length != bytes.length) {
                throw new ImagingException("Updated data size mismatch: " + this.bytes.length + " vs. " + bytes.length);
            }
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        }

        @Override
        public void writeItem(BinaryOutputStream bos) throws IOException, ImagingException {
            bos.write(this.bytes);
        }
    }
}

