/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.common.PackBits;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.common.ZlibDeflate;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.itu_t4.T4AndT6Compression;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSummary;
import org.apache.commons.imaging.mylzw.MyLzwCompressor;

public abstract class TiffImageWriterBase {
    private static final int MAX_PIXELS_FOR_RGB = 0x100000;
    protected final ByteOrder byteOrder;

    protected static int imageDataPaddingLength(int dataLength) {
        return (4 - dataLength % 4) % 4;
    }

    public TiffImageWriterBase() {
        this.byteOrder = TiffConstants.DEFAULT_TIFF_BYTE_ORDER;
    }

    public TiffImageWriterBase(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    private void applyPredictor(int width, int bytesPerSample, byte[] b) {
        int nBytesPerRow = bytesPerSample * width;
        int nRows = b.length / nBytesPerRow;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int offset = iRow * nBytesPerRow;
            for (int i = nBytesPerRow - 1; i >= bytesPerSample; --i) {
                int n = offset + i;
                b[n] = (byte)(b[n] - b[offset + i - bytesPerSample]);
            }
        }
    }

    private boolean checkForActualAlpha(BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        int nRowsPerRead = 0x100000 / width;
        if (nRowsPerRead < 1) {
            nRowsPerRead = 1;
        }
        int nReads = (height + nRowsPerRead - 1) / nRowsPerRead;
        int[] argb = Allocator.intArray(nRowsPerRead * width);
        for (int iRead = 0; iRead < nReads; ++iRead) {
            int i0 = iRead * nRowsPerRead;
            int i1 = i0 + nRowsPerRead > height ? height : i0 + nRowsPerRead;
            src.getRGB(0, i0, width, i1 - i0, argb, 0, width);
            int n = (i1 - i0) * width;
            for (int i = 0; i < n; ++i) {
                if ((argb[i] & 0xFF000000) == -16777216) continue;
                return true;
            }
        }
        return false;
    }

    private void combineUserExifIntoFinalExif(TiffOutputSet userExif, TiffOutputSet outputSet) throws ImagingException {
        List<TiffOutputDirectory> outputDirectories = outputSet.getDirectories();
        outputDirectories.sort(TiffOutputDirectory.COMPARATOR);
        for (TiffOutputDirectory userDirectory : userExif.getDirectories()) {
            int location = Collections.binarySearch(outputDirectories, userDirectory, TiffOutputDirectory.COMPARATOR);
            if (location < 0) {
                outputSet.addDirectory(userDirectory);
                continue;
            }
            TiffOutputDirectory outputDirectory = outputDirectories.get(location);
            for (TiffOutputField userField : userDirectory) {
                if (outputDirectory.findField(userField.tagInfo) != null) continue;
                outputDirectory.add(userField);
            }
        }
    }

    private byte[][] getStrips(BufferedImage src, int samplesPerPixel, int bitsPerSample, int rowsPerStrip) {
        int width = src.getWidth();
        int height = src.getHeight();
        int stripCount = (height + rowsPerStrip - 1) / rowsPerStrip;
        byte[][] result = new byte[Allocator.check(stripCount)][];
        int remainingRows = height;
        for (int i = 0; i < stripCount; ++i) {
            int rowsInStrip = Math.min(rowsPerStrip, remainingRows);
            remainingRows -= rowsInStrip;
            int bitsInRow = bitsPerSample * samplesPerPixel * width;
            int bytesPerRow = (bitsInRow + 7) / 8;
            int bytesInStrip = rowsInStrip * bytesPerRow;
            byte[] uncompressed = Allocator.byteArray(bytesInStrip);
            int counter = 0;
            int stop = i * rowsPerStrip + rowsPerStrip;
            for (int y = i * rowsPerStrip; y < height && y < stop; ++y) {
                int bitCache = 0;
                int bitsInCache = 0;
                for (int x = 0; x < width; ++x) {
                    int rgb = src.getRGB(x, y);
                    int red = 0xFF & rgb >> 16;
                    int green = 0xFF & rgb >> 8;
                    int blue = 0xFF & rgb >> 0;
                    if (bitsPerSample == 1) {
                        int sample = (red + green + blue) / 3;
                        sample = sample > 127 ? 0 : 1;
                        bitCache <<= 1;
                        bitCache |= sample;
                        if (++bitsInCache != 8) continue;
                        uncompressed[counter++] = (byte)bitCache;
                        bitCache = 0;
                        bitsInCache = 0;
                        continue;
                    }
                    if (samplesPerPixel == 4) {
                        uncompressed[counter++] = (byte)red;
                        uncompressed[counter++] = (byte)green;
                        uncompressed[counter++] = (byte)blue;
                        uncompressed[counter++] = (byte)(rgb >> 24);
                        continue;
                    }
                    uncompressed[counter++] = (byte)red;
                    uncompressed[counter++] = (byte)green;
                    uncompressed[counter++] = (byte)blue;
                }
                if (bitsInCache <= 0) continue;
                uncompressed[counter++] = (byte)(bitCache <<= 8 - bitsInCache);
            }
            result[i] = uncompressed;
        }
        return result;
    }

    protected TiffOutputSummary validateDirectories(TiffOutputSet outputSet) throws ImagingException {
        if (outputSet.isEmpty()) {
            throw new ImagingException("No directories.");
        }
        TiffOutputDirectory exifDirectory = null;
        TiffOutputDirectory gpsDirectory = null;
        TiffOutputDirectory interoperabilityDirectory = null;
        TiffOutputField exifDirectoryOffsetField = null;
        TiffOutputField gpsDirectoryOffsetField = null;
        TiffOutputField interoperabilityDirectoryOffsetField = null;
        ArrayList<Integer> directoryIndices = new ArrayList<Integer>();
        HashMap<Integer, TiffOutputDirectory> directoryTypeMap = new HashMap<Integer, TiffOutputDirectory>();
        for (TiffOutputDirectory directory : outputSet) {
            block33: {
                int dirType;
                block32: {
                    dirType = directory.getType();
                    directoryTypeMap.put(dirType, directory);
                    if (dirType >= 0) break block32;
                    switch (dirType) {
                        case -2: {
                            if (exifDirectory != null) {
                                throw new ImagingException("More than one EXIF directory.");
                            }
                            exifDirectory = directory;
                            break block33;
                        }
                        case -3: {
                            if (gpsDirectory != null) {
                                throw new ImagingException("More than one GPS directory.");
                            }
                            gpsDirectory = directory;
                            break block33;
                        }
                        case -4: {
                            if (interoperabilityDirectory != null) {
                                throw new ImagingException("More than one Interoperability directory.");
                            }
                            interoperabilityDirectory = directory;
                            break block33;
                        }
                        default: {
                            throw new ImagingException("Unknown directory: " + dirType);
                        }
                    }
                }
                if (directoryIndices.contains(dirType)) {
                    throw new ImagingException("More than one directory with index: " + dirType + ".");
                }
                directoryIndices.add(dirType);
            }
            HashSet<Integer> fieldTags = new HashSet<Integer>();
            for (TiffOutputField field : directory) {
                if (fieldTags.contains(field.tag)) {
                    throw new ImagingException("Tag (" + field.tagInfo.getDescription() + ") appears twice in directory.");
                }
                fieldTags.add(field.tag);
                if (field.tag == ExifTagConstants.EXIF_TAG_EXIF_OFFSET.tag) {
                    if (exifDirectoryOffsetField != null) {
                        throw new ImagingException("More than one Exif directory offset field.");
                    }
                    exifDirectoryOffsetField = field;
                    continue;
                }
                if (field.tag == ExifTagConstants.EXIF_TAG_INTEROP_OFFSET.tag) {
                    if (interoperabilityDirectoryOffsetField != null) {
                        throw new ImagingException("More than one Interoperability directory offset field.");
                    }
                    interoperabilityDirectoryOffsetField = field;
                    continue;
                }
                if (field.tag != ExifTagConstants.EXIF_TAG_GPSINFO.tag) continue;
                if (gpsDirectoryOffsetField != null) {
                    throw new ImagingException("More than one GPS directory offset field.");
                }
                gpsDirectoryOffsetField = field;
            }
        }
        if (directoryIndices.isEmpty()) {
            throw new ImagingException("Missing root directory.");
        }
        directoryIndices.sort(null);
        TiffOutputDirectory previousDirectory = null;
        for (int i = 0; i < directoryIndices.size(); ++i) {
            Integer index = (Integer)directoryIndices.get(i);
            if (index != i) {
                throw new ImagingException("Missing directory: " + i + ".");
            }
            TiffOutputDirectory directory = (TiffOutputDirectory)directoryTypeMap.get(index);
            if (null != previousDirectory) {
                previousDirectory.setNextDirectory(directory);
            }
            previousDirectory = directory;
        }
        TiffOutputDirectory rootDirectory = (TiffOutputDirectory)directoryTypeMap.get(0);
        TiffOutputSummary result = new TiffOutputSummary(this.byteOrder, rootDirectory, directoryTypeMap);
        if (interoperabilityDirectory == null && interoperabilityDirectoryOffsetField != null) {
            throw new ImagingException("Output set has Interoperability Directory Offset field, but no Interoperability Directory");
        }
        if (interoperabilityDirectory != null) {
            if (exifDirectory == null) {
                exifDirectory = outputSet.addExifDirectory();
            }
            if (interoperabilityDirectoryOffsetField == null) {
                interoperabilityDirectoryOffsetField = TiffOutputField.createOffsetField(ExifTagConstants.EXIF_TAG_INTEROP_OFFSET, this.byteOrder);
                exifDirectory.add(interoperabilityDirectoryOffsetField);
            }
            result.add(interoperabilityDirectory, interoperabilityDirectoryOffsetField);
        }
        if (exifDirectory == null && exifDirectoryOffsetField != null) {
            throw new ImagingException("Output set has Exif Directory Offset field, but no Exif Directory");
        }
        if (exifDirectory != null) {
            if (exifDirectoryOffsetField == null) {
                exifDirectoryOffsetField = TiffOutputField.createOffsetField(ExifTagConstants.EXIF_TAG_EXIF_OFFSET, this.byteOrder);
                rootDirectory.add(exifDirectoryOffsetField);
            }
            result.add(exifDirectory, exifDirectoryOffsetField);
        }
        if (gpsDirectory == null && gpsDirectoryOffsetField != null) {
            throw new ImagingException("Output set has GPS Directory Offset field, but no GPS Directory");
        }
        if (gpsDirectory != null) {
            if (gpsDirectoryOffsetField == null) {
                gpsDirectoryOffsetField = TiffOutputField.createOffsetField(ExifTagConstants.EXIF_TAG_GPSINFO, this.byteOrder);
                rootDirectory.add(gpsDirectoryOffsetField);
            }
            result.add(gpsDirectory, gpsDirectoryOffsetField);
        }
        return result;
    }

    public abstract void write(OutputStream var1, TiffOutputSet var2) throws IOException, ImagingException;

    public void writeImage(BufferedImage src, OutputStream os, TiffImagingParameters params) throws ImagingException, IOException {
        int photometricInterpretation;
        int bitsPerSample;
        int samplesPerPixel;
        TiffOutputSet userExif = params.getOutputSet();
        String xmpXml = params.getXmpXml();
        PixelDensity pixelDensity = params.getPixelDensity();
        if (pixelDensity == null) {
            pixelDensity = PixelDensity.createFromPixelsPerInch(72.0, 72.0);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        ColorModel cModel = src.getColorModel();
        boolean hasAlpha = cModel.hasAlpha() && this.checkForActualAlpha(src);
        int compression = 5;
        short predictor = 1;
        int stripSizeInBits = 64000;
        Integer compressionParameter = params.getCompression();
        if (compressionParameter != null) {
            compression = compressionParameter;
            Integer stripSizeInBytes = params.getLzwCompressionBlockSize();
            if (stripSizeInBytes != null) {
                if (stripSizeInBytes < 8000) {
                    throw new ImagingException("Block size parameter " + stripSizeInBytes + " is less than 8000 minimum");
                }
                stripSizeInBits = stripSizeInBytes * 8;
            }
        }
        if (compression == 2 || compression == 3 || compression == 4) {
            samplesPerPixel = 1;
            bitsPerSample = 1;
            photometricInterpretation = 0;
        } else {
            samplesPerPixel = hasAlpha ? 4 : 3;
            bitsPerSample = 8;
            photometricInterpretation = 2;
        }
        int rowsPerStrip = stripSizeInBits / (width * bitsPerSample * samplesPerPixel);
        rowsPerStrip = Math.max(1, rowsPerStrip);
        byte[][] strips = this.getStrips(src, samplesPerPixel, bitsPerSample, rowsPerStrip);
        int t4Options = 0;
        int t6Options = 0;
        switch (compression) {
            case 2: {
                for (int i2 = 0; i2 < strips.length; ++i2) {
                    strips[i2] = T4AndT6Compression.compressModifiedHuffman(strips[i2], width, strips[i2].length / ((width + 7) / 8));
                }
                break;
            }
            case 3: {
                boolean usesUncompressedMode;
                Integer t4Parameter = params.getT4Options();
                if (t4Parameter != null) {
                    t4Options = t4Parameter;
                }
                boolean is2D = ((t4Options &= 7) & 1) != 0;
                boolean bl = usesUncompressedMode = (t4Options & 2) != 0;
                if (usesUncompressedMode) {
                    throw new ImagingException("T.4 compression with the uncompressed mode extension is not yet supported");
                }
                boolean hasFillBitsBeforeEOL = (t4Options & 4) != 0;
                for (int i3 = 0; i3 < strips.length; ++i3) {
                    strips[i3] = is2D ? T4AndT6Compression.compressT4_2D(strips[i3], width, strips[i3].length / ((width + 7) / 8), hasFillBitsBeforeEOL, rowsPerStrip) : T4AndT6Compression.compressT4_1D(strips[i3], width, strips[i3].length / ((width + 7) / 8), hasFillBitsBeforeEOL);
                }
                break;
            }
            case 4: {
                boolean usesUncompressedMode;
                Integer t6Parameter = params.getT6Options();
                if (t6Parameter != null) {
                    t6Options = t6Parameter;
                }
                boolean bl = usesUncompressedMode = ((t6Options &= 4) & 2) != 0;
                if (usesUncompressedMode) {
                    throw new ImagingException("T.6 compression with the uncompressed mode extension is not yet supported");
                }
                for (int i4 = 0; i4 < strips.length; ++i4) {
                    strips[i4] = T4AndT6Compression.compressT6(strips[i4], width, strips[i4].length / ((width + 7) / 8));
                }
                break;
            }
            case 32773: {
                for (int i5 = 0; i5 < strips.length; ++i5) {
                    strips[i5] = new PackBits().compress(strips[i5]);
                }
                break;
            }
            case 5: {
                predictor = 2;
                for (int i6 = 0; i6 < strips.length; ++i6) {
                    byte[] uncompressed = strips[i6];
                    this.applyPredictor(width, samplesPerPixel, strips[i6]);
                    int LZW_MINIMUM_CODE_SIZE = 8;
                    MyLzwCompressor compressor = new MyLzwCompressor(8, ByteOrder.BIG_ENDIAN, true);
                    byte[] compressed = compressor.compress(uncompressed);
                    strips[i6] = compressed;
                }
                break;
            }
            case 8: {
                predictor = 2;
                for (int i7 = 0; i7 < strips.length; ++i7) {
                    this.applyPredictor(width, samplesPerPixel, strips[i7]);
                    strips[i7] = ZlibDeflate.compress(strips[i7]);
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ImagingException("Invalid compression parameter (Only CCITT 1D/Group 3/Group 4, LZW, Packbits, Zlib Deflate and uncompressed supported).");
            }
        }
        TiffElement.DataElement[] imageData = new TiffElement.DataElement[strips.length];
        Arrays.setAll(imageData, i -> new TiffImageData.Data(0L, strips[i].length, strips[i]));
        TiffOutputSet outputSet = new TiffOutputSet(this.byteOrder);
        TiffOutputDirectory directory = outputSet.addRootDirectory();
        directory.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, width);
        directory.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, height);
        directory.add(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION, (short)photometricInterpretation);
        directory.add(TiffTagConstants.TIFF_TAG_COMPRESSION, (short)compression);
        directory.add(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL, (short)samplesPerPixel);
        switch (samplesPerPixel) {
            case 3: {
                directory.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, (short)bitsPerSample, (short)bitsPerSample, (short)bitsPerSample);
                break;
            }
            case 4: {
                directory.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, (short)bitsPerSample, (short)bitsPerSample, (short)bitsPerSample, (short)bitsPerSample);
                directory.add(TiffTagConstants.TIFF_TAG_EXTRA_SAMPLES, 2);
                break;
            }
            case 1: {
                directory.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, (short)bitsPerSample);
                break;
            }
        }
        directory.add(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP, rowsPerStrip);
        if (pixelDensity.isUnitless()) {
            directory.add(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT, (short)0);
            directory.add(TiffTagConstants.TIFF_TAG_XRESOLUTION, RationalNumber.valueOf(pixelDensity.getRawHorizontalDensity()));
            directory.add(TiffTagConstants.TIFF_TAG_YRESOLUTION, RationalNumber.valueOf(pixelDensity.getRawVerticalDensity()));
        } else if (pixelDensity.isInInches()) {
            directory.add(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT, (short)2);
            directory.add(TiffTagConstants.TIFF_TAG_XRESOLUTION, RationalNumber.valueOf(pixelDensity.horizontalDensityInches()));
            directory.add(TiffTagConstants.TIFF_TAG_YRESOLUTION, RationalNumber.valueOf(pixelDensity.verticalDensityInches()));
        } else {
            directory.add(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT, (short)1);
            directory.add(TiffTagConstants.TIFF_TAG_XRESOLUTION, RationalNumber.valueOf(pixelDensity.horizontalDensityCentimetres()));
            directory.add(TiffTagConstants.TIFF_TAG_YRESOLUTION, RationalNumber.valueOf(pixelDensity.verticalDensityCentimetres()));
        }
        if (t4Options != 0) {
            directory.add(TiffTagConstants.TIFF_TAG_T4_OPTIONS, t4Options);
        }
        if (t6Options != 0) {
            directory.add(TiffTagConstants.TIFF_TAG_T6_OPTIONS, t6Options);
        }
        if (null != xmpXml) {
            byte[] xmpXmlBytes = xmpXml.getBytes(StandardCharsets.UTF_8);
            directory.add(TiffTagConstants.TIFF_TAG_XMP, xmpXmlBytes);
        }
        if (predictor == 2) {
            directory.add(TiffTagConstants.TIFF_TAG_PREDICTOR, predictor);
        }
        TiffImageData.Strips tiffImageData = new TiffImageData.Strips(imageData, rowsPerStrip);
        directory.setTiffImageData(tiffImageData);
        if (userExif != null) {
            this.combineUserExifIntoFinalExif(userExif, outputSet);
        }
        this.write(os, outputSet);
    }

    protected void writeImageFileHeader(BinaryOutputStream bos) throws IOException {
        this.writeImageFileHeader(bos, 8L);
    }

    protected void writeImageFileHeader(BinaryOutputStream bos, long offsetToFirstIFD) throws IOException {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bos.write(73);
            bos.write(73);
        } else {
            bos.write(77);
            bos.write(77);
        }
        bos.write2Bytes(42);
        bos.write4Bytes((int)offsetToFirstIFD);
    }
}

