/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.itu_t4;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;

class BitInputStreamFlexible
extends FilterInputStream {
    private int cache;
    private int cacheBitsRemaining;
    private long bytesRead;

    BitInputStreamFlexible(InputStream is) {
        super(is);
    }

    public void flushCache() {
        this.cacheBitsRemaining = 0;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public int read() throws IOException {
        if (this.cacheBitsRemaining > 0) {
            throw new ImagingException("BitInputStream: incomplete bit read");
        }
        return this.in.read();
    }

    public final int readBits(int count) throws IOException {
        if (count <= 32) {
            int result = 0;
            if (this.cacheBitsRemaining > 0) {
                if (count >= this.cacheBitsRemaining) {
                    result = (1 << this.cacheBitsRemaining) - 1 & this.cache;
                    count -= this.cacheBitsRemaining;
                    this.cacheBitsRemaining = 0;
                } else {
                    this.cacheBitsRemaining -= count;
                    result = (1 << count) - 1 & this.cache >> this.cacheBitsRemaining;
                    count = 0;
                }
            }
            while (count >= 8) {
                this.cache = this.in.read();
                if (this.cache < 0) {
                    throw new ImagingException("Couldn't read bits");
                }
                ++this.bytesRead;
                result = result << 8 | 0xFF & this.cache;
                count -= 8;
            }
            if (count > 0) {
                this.cache = this.in.read();
                if (this.cache < 0) {
                    throw new ImagingException("Couldn't read bits");
                }
                ++this.bytesRead;
                this.cacheBitsRemaining = 8 - count;
                result = result << count | (1 << count) - 1 & this.cache >> this.cacheBitsRemaining;
                count = 0;
            }
            return result;
        }
        throw new ImagingException("BitInputStream: unknown error");
    }
}

