/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorCieLab;
import org.apache.commons.imaging.color.ColorCieLch;
import org.apache.commons.imaging.color.ColorCieLuv;
import org.apache.commons.imaging.color.ColorCmy;
import org.apache.commons.imaging.color.ColorCmyk;
import org.apache.commons.imaging.color.ColorDin99Lab;
import org.apache.commons.imaging.color.ColorHsl;
import org.apache.commons.imaging.color.ColorHsv;
import org.apache.commons.imaging.color.ColorHunterLab;
import org.apache.commons.imaging.color.ColorXyz;

public final class ColorConversions {
    private static final double REF_X = 95.047;
    private static final double REF_Y = 100.0;
    private static final double REF_Z = 108.883;
    private static final double XYZ_m = 7.787037;
    private static final double XYZ_t0 = 0.008856;

    public static int convertCIELabtoARGBTest(int cieL, int cieA, int cieB) {
        double var_Y = ((double)cieL * 100.0 / 255.0 + 16.0) / 116.0;
        double var_X = (double)cieA / 500.0 + var_Y;
        double var_Z = var_Y - (double)cieB / 200.0;
        var_X = ColorConversions.unPivotXYZ(var_X);
        var_Y = ColorConversions.unPivotXYZ(var_Y);
        var_Z = ColorConversions.unPivotXYZ(var_Z);
        double X = 95.047 * var_X;
        double Y = 100.0 * var_Y;
        double Z = 108.883 * var_Z;
        double var_X2 = X / 100.0;
        double var_Y2 = Y / 100.0;
        double var_Z2 = Z / 100.0;
        double var_R = var_X2 * 3.2406 + var_Y2 * -1.5372 + var_Z2 * -0.4986;
        double var_G = var_X2 * -0.9689 + var_Y2 * 1.8758 + var_Z2 * 0.0415;
        double var_B = var_X2 * 0.0557 + var_Y2 * -0.204 + var_Z2 * 1.057;
        var_R = ColorConversions.pivotRGB(var_R);
        var_G = ColorConversions.pivotRGB(var_G);
        var_B = ColorConversions.pivotRGB(var_B);
        double R = var_R * 255.0;
        double G = var_G * 255.0;
        double B = var_B * 255.0;
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static ColorCieLch convertCIELabtoCIELCH(ColorCieLab cielab) {
        return ColorConversions.convertCIELabtoCIELCH(cielab.L, cielab.a, cielab.b);
    }

    public static ColorCieLch convertCIELabtoCIELCH(double L, double a, double b) {
        double atanba = Math.atan2(b, a);
        double h = atanba > 0.0 ? Math.toDegrees(atanba) : Math.toDegrees(atanba) + 360.0;
        double C = Math.sqrt(ColorConversions.square(a) + ColorConversions.square(b));
        return new ColorCieLch(L, C, h);
    }

    public static ColorDin99Lab convertCIELabToDIN99bLab(ColorCieLab cie) {
        return ColorConversions.convertCIELabToDIN99bLab(cie.L, cie.a, cie.b);
    }

    public static ColorDin99Lab convertCIELabToDIN99bLab(double L, double a, double b) {
        double f;
        double e;
        double G;
        double FAC_1 = 100.0 / Math.log(2.58);
        double kE = 1.0;
        double kCH = 1.0;
        double ang = Math.toRadians(16.0);
        double L99 = 1.0 * FAC_1 * Math.log(1.0 + 0.0158 * L);
        double a99 = 0.0;
        double b99 = 0.0;
        if ((a != 0.0 || b != 0.0) && (G = Math.sqrt((e = a * Math.cos(ang) + b * Math.sin(ang)) * e + (f = 0.7 * (b * Math.cos(ang) - a * Math.sin(ang))) * f)) != 0.0) {
            double k = Math.log(1.0 + 0.045 * G) / (0.045 * G);
            a99 = k * e;
            b99 = k * f;
        }
        return new ColorDin99Lab(L99, a99, b99);
    }

    public static ColorDin99Lab convertCIELabToDIN99oLab(ColorCieLab cie) {
        return ColorConversions.convertCIELabToDIN99oLab(cie.L, cie.a, cie.b);
    }

    public static ColorDin99Lab convertCIELabToDIN99oLab(double L, double a, double b) {
        double kE = 1.0;
        double kCH = 1.0;
        double FAC_1 = 100.0 / Math.log(1.39);
        double ang = Math.toRadians(26.0);
        double L99o = FAC_1 / 1.0 * Math.log(1.0 + 0.0039 * L);
        double a99o = 0.0;
        double b99o = 0.0;
        if (a != 0.0 || b != 0.0) {
            double eo = a * Math.cos(ang) + b * Math.sin(ang);
            double fo = 0.83 * (b * Math.cos(ang) - a * Math.sin(ang));
            double Go = Math.sqrt(eo * eo + fo * fo);
            double C99o = Math.log(1.0 + 0.075 * Go) / 0.0435;
            double heofo = Math.atan2(fo, eo);
            double h99o = heofo + ang;
            a99o = C99o * Math.cos(h99o);
            b99o = C99o * Math.sin(h99o);
        }
        return new ColorDin99Lab(L99o, a99o, b99o);
    }

    public static ColorXyz convertCIELabtoXYZ(ColorCieLab cielab) {
        return ColorConversions.convertCIELabtoXYZ(cielab.L, cielab.a, cielab.b);
    }

    public static ColorXyz convertCIELabtoXYZ(double L, double a, double b) {
        double var_Y = (L + 16.0) / 116.0;
        double var_X = a / 500.0 + var_Y;
        double var_Z = var_Y - b / 200.0;
        var_Y = ColorConversions.unPivotXYZ(var_Y);
        var_X = ColorConversions.unPivotXYZ(var_X);
        var_Z = ColorConversions.unPivotXYZ(var_Z);
        double X = 95.047 * var_X;
        double Y = 100.0 * var_Y;
        double Z = 108.883 * var_Z;
        return new ColorXyz(X, Y, Z);
    }

    public static ColorCieLab convertCIELCHtoCIELab(ColorCieLch cielch) {
        return ColorConversions.convertCIELCHtoCIELab(cielch.L, cielch.C, cielch.h);
    }

    public static ColorCieLab convertCIELCHtoCIELab(double L, double C, double H) {
        double a = Math.cos(ColorConversions.degree_2_radian(H)) * C;
        double b = Math.sin(ColorConversions.degree_2_radian(H)) * C;
        return new ColorCieLab(L, a, b);
    }

    public static ColorXyz convertCIELuvtoXYZ(ColorCieLuv cielch) {
        return ColorConversions.convertCIELuvtoXYZ(cielch.L, cielch.u, cielch.v);
    }

    public static ColorXyz convertCIELuvtoXYZ(double L, double u, double v) {
        double var_Y = (L + 16.0) / 116.0;
        var_Y = ColorConversions.unPivotXYZ(var_Y);
        double ref_U = 0.19783982482140777;
        double ref_V = 0.46833630293240974;
        double var_U = u / (13.0 * L) + 0.19783982482140777;
        double var_V = v / (13.0 * L) + 0.46833630293240974;
        double Y = var_Y * 100.0;
        double X = -(9.0 * Y * var_U) / ((var_U - 4.0) * var_V - var_U * var_V);
        double Z = (9.0 * Y - 15.0 * var_V * Y - var_V * X) / (3.0 * var_V);
        return new ColorXyz(X, Y, Z);
    }

    public static ColorCmy convertCMYKtoCMY(ColorCmyk cmyk) {
        return ColorConversions.convertCMYKtoCMY(cmyk.C, cmyk.M, cmyk.Y, cmyk.K);
    }

    public static ColorCmy convertCMYKtoCMY(double C, double M, double Y, double K) {
        C = C * (1.0 - K) + K;
        M = M * (1.0 - K) + K;
        Y = Y * (1.0 - K) + K;
        return new ColorCmy(C, M, Y);
    }

    public static int convertCMYKtoRGB(int c, int m, int y, int k) {
        double C = (double)c / 255.0;
        double M = (double)m / 255.0;
        double Y = (double)y / 255.0;
        double K = (double)k / 255.0;
        return ColorConversions.convertCMYtoRGB(ColorConversions.convertCMYKtoCMY(C, M, Y, K));
    }

    public static int convertCMYKtoRGB_Adobe(int sc, int sm, int sy, int sk) {
        int red = 255 - (sc + sk);
        int green = 255 - (sm + sk);
        int blue = 255 - (sy + sk);
        return ColorConversions.convertRGBtoRGB(red, green, blue);
    }

    public static ColorCmyk convertCMYtoCMYK(ColorCmy cmy) {
        double C = cmy.C;
        double M = cmy.M;
        double Y = cmy.Y;
        double var_K = 1.0;
        if (C < var_K) {
            var_K = C;
        }
        if (M < var_K) {
            var_K = M;
        }
        if (Y < var_K) {
            var_K = Y;
        }
        if (var_K == 1.0) {
            C = 0.0;
            M = 0.0;
            Y = 0.0;
        } else {
            C = (C - var_K) / (1.0 - var_K);
            M = (M - var_K) / (1.0 - var_K);
            Y = (Y - var_K) / (1.0 - var_K);
        }
        return new ColorCmyk(C, M, Y, var_K);
    }

    public static int convertCMYtoRGB(ColorCmy cmy) {
        double R = (1.0 - cmy.C) * 255.0;
        double G = (1.0 - cmy.M) * 255.0;
        double B = (1.0 - cmy.Y) * 255.0;
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static ColorCieLab convertDIN99bLabToCIELab(ColorDin99Lab dinb) {
        return ColorConversions.convertDIN99bLabToCIELab(dinb.L99, dinb.a99, dinb.b99);
    }

    public static ColorCieLab convertDIN99bLabToCIELab(double L99b, double a99b, double b99b) {
        double kE = 1.0;
        double kCH = 1.0;
        double FAC_1 = 100.0 / Math.log(2.58);
        double ang = Math.toRadians(16.0);
        double hef = Math.atan2(b99b, a99b);
        double C = Math.sqrt(a99b * a99b + b99b * b99b);
        double G = (Math.exp(0.045 * C * 1.0 * 1.0) - 1.0) / 0.045;
        double e = G * Math.cos(hef);
        double f = G * Math.sin(hef) / 0.7;
        double L = (Math.exp(L99b * 1.0 / FAC_1) - 1.0) / 0.0158;
        double a = e * Math.cos(ang) - f * Math.sin(ang);
        double b = e * Math.sin(ang) + f * Math.cos(ang);
        return new ColorCieLab(L, a, b);
    }

    public static ColorCieLab convertDIN99oLabToCIELab(ColorDin99Lab dino) {
        return ColorConversions.convertDIN99oLabToCIELab(dino.L99, dino.a99, dino.b99);
    }

    public static ColorCieLab convertDIN99oLabToCIELab(double L99o, double a99o, double b99o) {
        double kE = 1.0;
        double kCH = 1.0;
        double FAC_1 = 100.0 / Math.log(1.39);
        double ang = Math.toRadians(26.0);
        double L = (Math.exp(L99o * 1.0 / FAC_1) - 1.0) / 0.0039;
        double h99ef = Math.atan2(b99o, a99o);
        double heofo = h99ef - ang;
        double C99 = Math.sqrt(a99o * a99o + b99o * b99o);
        double G = (Math.exp(0.0435 * C99) - 1.0) / 0.075;
        double e = G * Math.cos(heofo);
        double f = G * Math.sin(heofo);
        double a = e * Math.cos(ang) - f / 0.83 * Math.sin(ang);
        double b = e * Math.sin(ang) + f / 0.83 * Math.cos(ang);
        return new ColorCieLab(L, a, b);
    }

    public static int convertHSLtoRGB(ColorHsl hsl) {
        return ColorConversions.convertHSLtoRGB(hsl.H, hsl.S, hsl.L);
    }

    public static int convertHSLtoRGB(double H, double S, double L) {
        double B;
        double G;
        double R;
        if (S == 0.0) {
            R = L * 255.0;
            G = L * 255.0;
            B = L * 255.0;
        } else {
            double var_2 = L < 0.5 ? L * (1.0 + S) : L + S - S * L;
            double var_1 = 2.0 * L - var_2;
            R = 255.0 * ColorConversions.convertHuetoRGB(var_1, var_2, H + 0.3333333333333333);
            G = 255.0 * ColorConversions.convertHuetoRGB(var_1, var_2, H);
            B = 255.0 * ColorConversions.convertHuetoRGB(var_1, var_2, H - 0.3333333333333333);
        }
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static int convertHSVtoRGB(ColorHsv HSV) {
        return ColorConversions.convertHSVtoRGB(HSV.H, HSV.S, HSV.V);
    }

    public static int convertHSVtoRGB(double H, double S, double V) {
        double B;
        double G;
        double R;
        if (S == 0.0) {
            R = V * 255.0;
            G = V * 255.0;
            B = V * 255.0;
        } else {
            double var_b;
            double var_g;
            double var_r;
            double var_h = H * 6.0;
            if (var_h == 6.0) {
                var_h = 0.0;
            }
            double var_i = Math.floor(var_h);
            double var_1 = V * (1.0 - S);
            double var_2 = V * (1.0 - S * (var_h - var_i));
            double var_3 = V * (1.0 - S * (1.0 - (var_h - var_i)));
            if (var_i == 0.0) {
                var_r = V;
                var_g = var_3;
                var_b = var_1;
            } else if (var_i == 1.0) {
                var_r = var_2;
                var_g = V;
                var_b = var_1;
            } else if (var_i == 2.0) {
                var_r = var_1;
                var_g = V;
                var_b = var_3;
            } else if (var_i == 3.0) {
                var_r = var_1;
                var_g = var_2;
                var_b = V;
            } else if (var_i == 4.0) {
                var_r = var_3;
                var_g = var_1;
                var_b = V;
            } else {
                var_r = V;
                var_g = var_1;
                var_b = var_2;
            }
            R = var_r * 255.0;
            G = var_g * 255.0;
            B = var_b * 255.0;
        }
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    private static double convertHuetoRGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }

    public static ColorXyz convertHunterLabtoXYZ(ColorHunterLab cielab) {
        return ColorConversions.convertHunterLabtoXYZ(cielab.L, cielab.a, cielab.b);
    }

    public static ColorXyz convertHunterLabtoXYZ(double L, double a, double b) {
        double var_Y = L / 10.0;
        double var_X = a / 17.5 * L / 10.0;
        double var_Z = b / 7.0 * L / 10.0;
        double Y = Math.pow(var_Y, 2.0);
        double X = (var_X + Y) / 1.02;
        double Z = -(var_Z - Y) / 0.847;
        return new ColorXyz(X, Y, Z);
    }

    public static ColorCmy convertRGBtoCMY(int rgb) {
        int R = 0xFF & rgb >> 16;
        int G = 0xFF & rgb >> 8;
        int B = 0xFF & rgb >> 0;
        double C = 1.0 - (double)R / 255.0;
        double M = 1.0 - (double)G / 255.0;
        double Y = 1.0 - (double)B / 255.0;
        return new ColorCmy(C, M, Y);
    }

    public static ColorHsl convertRGBtoHSL(int rgb) {
        double S;
        double H;
        double var_Max;
        int R = 0xFF & rgb >> 16;
        int G = 0xFF & rgb >> 8;
        int B = 0xFF & rgb >> 0;
        double var_R = (double)R / 255.0;
        double var_G = (double)G / 255.0;
        double var_B = (double)B / 255.0;
        double var_Min = Math.min(var_R, Math.min(var_G, var_B));
        boolean maxIsR = false;
        boolean maxIsG = false;
        if (var_R >= var_G && var_R >= var_B) {
            var_Max = var_R;
            maxIsR = true;
        } else if (var_G > var_B) {
            var_Max = var_G;
            maxIsG = true;
        } else {
            var_Max = var_B;
        }
        double del_Max = var_Max - var_Min;
        double L = (var_Max + var_Min) / 2.0;
        if (del_Max == 0.0) {
            H = 0.0;
            S = 0.0;
        } else {
            S = L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0 - var_Max - var_Min);
            double del_R = ((var_Max - var_R) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - var_G) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - var_B) / 6.0 + del_Max / 2.0) / del_Max;
            H = maxIsR ? del_B - del_G : (maxIsG ? 0.3333333333333333 + del_R - del_B : 0.6666666666666666 + del_G - del_R);
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        return new ColorHsl(H, S, L);
    }

    public static ColorHsv convertRGBtoHSV(int rgb) {
        double S;
        double H;
        double var_Max;
        int R = 0xFF & rgb >> 16;
        int G = 0xFF & rgb >> 8;
        int B = 0xFF & rgb >> 0;
        double var_R = (double)R / 255.0;
        double var_G = (double)G / 255.0;
        double var_B = (double)B / 255.0;
        double var_Min = Math.min(var_R, Math.min(var_G, var_B));
        boolean maxIsR = false;
        boolean maxIsG = false;
        if (var_R >= var_G && var_R >= var_B) {
            var_Max = var_R;
            maxIsR = true;
        } else if (var_G > var_B) {
            var_Max = var_G;
            maxIsG = true;
        } else {
            var_Max = var_B;
        }
        double del_Max = var_Max - var_Min;
        double V = var_Max;
        if (del_Max == 0.0) {
            H = 0.0;
            S = 0.0;
        } else {
            S = del_Max / var_Max;
            double del_R = ((var_Max - var_R) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - var_G) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - var_B) / 6.0 + del_Max / 2.0) / del_Max;
            H = maxIsR ? del_B - del_G : (maxIsG ? 0.3333333333333333 + del_R - del_B : 0.6666666666666666 + del_G - del_R);
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        return new ColorHsv(H, S, V);
    }

    private static int convertRGBtoRGB(double R, double G, double B) {
        int red = (int)Math.round(R);
        int green = (int)Math.round(G);
        int blue = (int)Math.round(B);
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        return 0xFF000000 | red << 16 | green << 8 | blue << 0;
    }

    private static int convertRGBtoRGB(int red, int green, int blue) {
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        return 0xFF000000 | red << 16 | green << 8 | blue << 0;
    }

    public static ColorXyz convertRGBtoXYZ(int rgb) {
        int r = 0xFF & rgb >> 16;
        int g = 0xFF & rgb >> 8;
        int b = 0xFF & rgb >> 0;
        double var_R = (double)r / 255.0;
        double var_G = (double)g / 255.0;
        double var_B = (double)b / 255.0;
        var_R = ColorConversions.unPivotRGB(var_R);
        var_G = ColorConversions.unPivotRGB(var_G);
        var_B = ColorConversions.unPivotRGB(var_B);
        double X = (var_R *= 100.0) * 0.4124564 + (var_G *= 100.0) * 0.3575761 + (var_B *= 100.0) * 0.1804375;
        double Y = var_R * 0.2126729 + var_G * 0.7151522 + var_B * 0.072175;
        double Z = var_R * 0.0193339 + var_G * 0.119192 + var_B * 0.9503041;
        return new ColorXyz(X, Y, Z);
    }

    public static ColorCieLab convertXYZtoCIELab(ColorXyz xyz) {
        return ColorConversions.convertXYZtoCIELab(xyz.X, xyz.Y, xyz.Z);
    }

    public static ColorCieLab convertXYZtoCIELab(double X, double Y, double Z) {
        double var_X = X / 95.047;
        double var_Y = Y / 100.0;
        double var_Z = Z / 108.883;
        var_X = ColorConversions.pivotXYZ(var_X);
        var_Y = ColorConversions.pivotXYZ(var_Y);
        var_Z = ColorConversions.pivotXYZ(var_Z);
        double L = Math.max(0.0, 116.0 * var_Y - 16.0);
        double a = 500.0 * (var_X - var_Y);
        double b = 200.0 * (var_Y - var_Z);
        return new ColorCieLab(L, a, b);
    }

    public static ColorCieLuv convertXYZtoCIELuv(ColorXyz xyz) {
        return ColorConversions.convertXYZtoCIELuv(xyz.X, xyz.Y, xyz.Z);
    }

    public static ColorCieLuv convertXYZtoCIELuv(double X, double Y, double Z) {
        double var_U = 4.0 * X / (X + 15.0 * Y + 3.0 * Z);
        double var_V = 9.0 * Y / (X + 15.0 * Y + 3.0 * Z);
        double var_Y = Y / 100.0;
        var_Y = ColorConversions.pivotXYZ(var_Y);
        double ref_U = 0.19783982482140777;
        double ref_V = 0.46833630293240974;
        double L = 116.0 * var_Y - 16.0;
        double u = 13.0 * L * (var_U - 0.19783982482140777);
        double v = 13.0 * L * (var_V - 0.46833630293240974);
        return new ColorCieLuv(L, u, v);
    }

    public static ColorHunterLab convertXYZtoHunterLab(ColorXyz xyz) {
        return ColorConversions.convertXYZtoHunterLab(xyz.X, xyz.Y, xyz.Z);
    }

    public static ColorHunterLab convertXYZtoHunterLab(double X, double Y, double Z) {
        double L = 10.0 * Math.sqrt(Y);
        double a = Y == 0.0 ? 0.0 : 17.5 * ((1.02 * X - Y) / Math.sqrt(Y));
        double b = Y == 0.0 ? 0.0 : 7.0 * ((Y - 0.847 * Z) / Math.sqrt(Y));
        return new ColorHunterLab(L, a, b);
    }

    public static int convertXYZtoRGB(ColorXyz xyz) {
        return ColorConversions.convertXYZtoRGB(xyz.X, xyz.Y, xyz.Z);
    }

    public static int convertXYZtoRGB(double X, double Y, double Z) {
        double var_X = X / 100.0;
        double var_Y = Y / 100.0;
        double var_Z = Z / 100.0;
        double var_R = var_X * 3.2404542 + var_Y * -1.5371385 + var_Z * -0.4985314;
        double var_G = var_X * -0.969266 + var_Y * 1.8760108 + var_Z * 0.041556;
        double var_B = var_X * 0.0556434 + var_Y * -0.2040259 + var_Z * 1.0572252;
        var_R = ColorConversions.pivotRGB(var_R);
        var_G = ColorConversions.pivotRGB(var_G);
        var_B = ColorConversions.pivotRGB(var_B);
        double R = var_R * 255.0;
        double G = var_G * 255.0;
        double B = var_B * 255.0;
        return ColorConversions.convertRGBtoRGB(R, G, B);
    }

    public static double degree_2_radian(double degree) {
        return degree * Math.PI / 180.0;
    }

    private static double pivotRGB(double n) {
        n = n > 0.0031308 ? 1.055 * Math.pow(n, 0.4166666666666667) - 0.055 : 12.92 * n;
        return n;
    }

    private static double pivotXYZ(double n) {
        n = n > 0.008856 ? Math.pow(n, 0.3333333333333333) : 7.787037 * n + 0.13793103448275862;
        return n;
    }

    public static double radian_2_degree(double radian) {
        return radian * 180.0 / Math.PI;
    }

    private static double square(double f) {
        return f * f;
    }

    private static double unPivotRGB(double n) {
        n = n > 0.04045 ? Math.pow((n + 0.055) / 1.055, 2.4) : (n /= 12.92);
        return n;
    }

    private static double unPivotXYZ(double n) {
        double nCube = Math.pow(n, 3.0);
        n = nCube > 0.008856 ? nCube : (n - 0.13793103448275862) / 7.787037;
        return n;
    }

    private ColorConversions() {
    }
}

