/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractOrigin;

final class InputStreamByteSource
extends ByteSource {
    private static final int BLOCK_SIZE = 1024;
    private final InputStream inputStream;
    private Block headBlock;
    private byte[] readBuffer;
    private long streamLength = -1L;

    InputStreamByteSource(InputStream inputStream, String fileName) {
        super((AbstractOrigin<?, ?>)new AbstractOrigin.InputStreamOrigin(inputStream), fileName);
        this.inputStream = new BufferedInputStream(inputStream);
    }

    @Override
    public byte[] getByteArray(long position, int length) throws IOException {
        int read;
        if (position < 0L || length < 0 || position + (long)length < 0L || position + (long)length > this.size()) {
            throw new ImagingException("Could not read block (block start: " + position + ", block length: " + length + ", data length: " + this.streamLength + ").");
        }
        InputStream cis = this.getInputStream();
        BinaryFunctions.skipBytes(cis, position);
        byte[] bytes = Allocator.byteArray(length);
        int total = 0;
        do {
            if ((read = cis.read(bytes, total, bytes.length - total)) >= 1) continue;
            throw new ImagingException("Could not read block.");
        } while ((total += read) < length);
        return bytes;
    }

    private Block getFirstBlock() throws IOException {
        if (null == this.headBlock) {
            this.headBlock = this.readBlock();
        }
        return this.headBlock;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BlockInputStream();
    }

    private Block readBlock() throws IOException {
        int read;
        if (null == this.readBuffer) {
            this.readBuffer = new byte[1024];
        }
        if ((read = this.inputStream.read(this.readBuffer)) < 1) {
            return null;
        }
        if (read < 1024) {
            return new Block(Arrays.copyOf(this.readBuffer, read));
        }
        byte[] result = this.readBuffer;
        this.readBuffer = null;
        return new Block(result);
    }

    @Override
    public long size() throws IOException {
        if (this.streamLength >= 0L) {
            return this.streamLength;
        }
        try (InputStream cis = this.getInputStream();){
            long result;
            this.streamLength = result = IOUtils.consume((InputStream)cis);
            long l = result;
            return l;
        }
    }

    private final class BlockInputStream
    extends InputStream {
        private Block block;
        private boolean readFirst;
        private int blockIndex;

        private BlockInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (null == this.block) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = InputStreamByteSource.this.getFirstBlock();
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (null == this.block) {
                return -1;
            }
            if (this.blockIndex >= this.block.bytes.length) {
                return -1;
            }
            return 0xFF & this.block.bytes[this.blockIndex++];
        }

        @Override
        public int read(byte[] array, int off, int len) throws IOException {
            Objects.requireNonNull(array, "array");
            if (off < 0 || off > array.length || len < 0 || off + len > array.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (null == this.block) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = InputStreamByteSource.this.getFirstBlock();
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (null == this.block) {
                return -1;
            }
            if (this.blockIndex >= this.block.bytes.length) {
                return -1;
            }
            int readSize = Math.min(len, this.block.bytes.length - this.blockIndex);
            System.arraycopy(this.block.bytes, this.blockIndex, array, off, readSize);
            this.blockIndex += readSize;
            return readSize;
        }

        @Override
        public long skip(long n) throws IOException {
            long remaining;
            int readSize;
            if (n <= 0L) {
                return 0L;
            }
            for (remaining = n; remaining > 0L; remaining -= (long)readSize) {
                if (null == this.block) {
                    if (this.readFirst) {
                        return -1L;
                    }
                    this.block = InputStreamByteSource.this.getFirstBlock();
                    this.readFirst = true;
                }
                if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                    this.block = this.block.getNext();
                    this.blockIndex = 0;
                }
                if (null == this.block || this.blockIndex >= this.block.bytes.length) break;
                readSize = Math.min((int)Math.min(1024L, remaining), this.block.bytes.length - this.blockIndex);
                this.blockIndex += readSize;
            }
            return n - remaining;
        }
    }

    private final class Block {
        public final byte[] bytes;
        private Block next;
        private boolean triedNext;

        Block(byte[] bytes) {
            this.bytes = bytes;
        }

        public Block getNext() throws IOException {
            if (null != this.next) {
                return this.next;
            }
            if (this.triedNext) {
                return null;
            }
            this.triedNext = true;
            this.next = InputStreamByteSource.this.readBlock();
            return this.next;
        }
    }
}

