/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.commons.imaging.bytesource.InputStreamByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.io.build.AbstractOrigin;

public class ByteSource {
    private final String fileName;
    private final AbstractOrigin<?, ?> origin;

    public static ByteSource array(byte[] array) {
        return new ByteSource((AbstractOrigin<?, ?>)new AbstractOrigin.ByteArrayOrigin(array), null);
    }

    public static ByteSource array(byte[] array, String name) {
        return new ByteSource((AbstractOrigin<?, ?>)new AbstractOrigin.ByteArrayOrigin(array), name);
    }

    public static ByteSource file(File file) {
        return new ByteSource((AbstractOrigin<?, ?>)new AbstractOrigin.FileOrigin(file), file.getName());
    }

    public static ByteSource inputStream(InputStream is, String name) {
        return new InputStreamByteSource(is, name);
    }

    public ByteSource(AbstractOrigin<?, ?> origin, String fileName) {
        this.fileName = fileName;
        this.origin = origin;
    }

    public byte[] getByteArray(long position, int length) throws IOException {
        byte[] bytes = this.origin.getByteArray();
        int start = Math.toIntExact(position);
        if (start < 0 || length < 0 || start + length < 0 || start + length > bytes.length) {
            throw new IllegalArgumentException("Couldn't read array (start: " + start + ", length: " + length + ", data length: " + bytes.length + ").");
        }
        return Arrays.copyOfRange(bytes, start, start + length);
    }

    public final String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        return this.origin.getInputStream(new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getInputStream(long start) throws IOException {
        InputStream is = null;
        boolean succeeded = false;
        try {
            is = this.getInputStream();
            BinaryFunctions.skipBytes(is, start);
            succeeded = true;
        }
        finally {
            if (!succeeded && is != null) {
                is.close();
            }
        }
        return is;
    }

    public long size() throws IOException {
        return this.origin.getByteArray().length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getFileName() + "]";
    }
}

