/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.internal;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;

public class Util {
    private Util() {
    }

    public static ImageParser<?> getImageParser(ImageFormat format) {
        return Util.getImageParser(parser -> parser.canAcceptType(format), () -> new IllegalArgumentException("Unknown Format: " + format));
    }

    public static ImageParser<?> getImageParser(String fileExtension) {
        return Util.getImageParser(parser -> parser.canAcceptExtension(fileExtension), () -> new IllegalArgumentException("Unknown Extension: " + fileExtension));
    }

    private static ImageParser<?> getImageParser(Predicate<ImageParser<?>> pred, Supplier<? extends RuntimeException> supplier) {
        return ImageParser.getAllImageParsers().stream().filter(pred).findFirst().orElseThrow(supplier);
    }

    public static ImageParser<?> getImageParser(ByteSource byteSource) throws IOException {
        ImageFormat format = Imaging.guessFormat(byteSource);
        if (!format.equals(ImageFormats.UNKNOWN)) {
            return Util.getImageParser(format);
        }
        String fileName = byteSource.getFileName();
        if (fileName != null) {
            return Util.getImageParser(fileName);
        }
        throw new IllegalArgumentException("Can't parse this format.");
    }
}

