/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractPartitionedRegionBuilder;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutBoundary;
import org.apache.commons.geometry.euclidean.twod.BoundarySource2D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.LinecastPoint2D;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.InteriorAngleLinePathConnector;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;
import org.apache.commons.numbers.core.Precision;

public final class RegionBSPTree2D
extends AbstractRegionBSPTree<Vector2D, RegionNode2D>
implements BoundarySource2D {
    private List<LinePath> boundaryPaths;

    public RegionBSPTree2D() {
        this(false);
    }

    public RegionBSPTree2D(boolean full) {
        super(full);
    }

    public RegionBSPTree2D copy() {
        RegionBSPTree2D result = RegionBSPTree2D.empty();
        result.copy((BSPTree)this);
        return result;
    }

    public Iterable<LineConvexSubset> boundaries() {
        return this.createBoundaryIterable(b -> (LineConvexSubset)b);
    }

    public Stream<LineConvexSubset> boundaryStream() {
        return StreamSupport.stream(this.boundaries().spliterator(), false);
    }

    public List<LineConvexSubset> getBoundaries() {
        return this.createBoundaryList(b -> (LineConvexSubset)b);
    }

    public List<LinePath> getBoundaryPaths() {
        if (this.boundaryPaths == null) {
            this.boundaryPaths = Collections.unmodifiableList(this.computeBoundaryPaths());
        }
        return this.boundaryPaths;
    }

    public void add(ConvexArea area) {
        this.union(area.toTree());
    }

    public List<ConvexArea> toConvex() {
        ArrayList<ConvexArea> result = new ArrayList<ConvexArea>();
        this.toConvexRecursive((RegionNode2D)this.getRoot(), ConvexArea.full(), result);
        return result;
    }

    private void toConvexRecursive(RegionNode2D node, ConvexArea nodeArea, List<? super ConvexArea> result) {
        if (node.isLeaf()) {
            if (node.isInside()) {
                result.add(nodeArea);
            }
        } else {
            Split<ConvexArea> split = nodeArea.split((Hyperplane<Vector2D>)node.getCutHyperplane());
            this.toConvexRecursive((RegionNode2D)node.getMinus(), (ConvexArea)split.getMinus(), result);
            this.toConvexRecursive((RegionNode2D)node.getPlus(), (ConvexArea)split.getPlus(), result);
        }
    }

    public Split<RegionBSPTree2D> split(Hyperplane<Vector2D> splitter) {
        return this.split(splitter, RegionBSPTree2D.empty(), RegionBSPTree2D.empty());
    }

    public Vector2D project(Vector2D pt) {
        BoundaryProjector2D projector = new BoundaryProjector2D(pt);
        this.accept((BSPTreeVisitor)projector);
        return (Vector2D)projector.getProjected();
    }

    @Override
    public RegionBSPTree2D toTree() {
        return this;
    }

    @Override
    public List<LinecastPoint2D> linecast(LineConvexSubset subset) {
        LinecastVisitor visitor = new LinecastVisitor(subset, false);
        this.accept(visitor);
        return visitor.getResults();
    }

    @Override
    public LinecastPoint2D linecastFirst(LineConvexSubset subset) {
        LinecastVisitor visitor = new LinecastVisitor(subset, true);
        this.accept(visitor);
        return visitor.getFirstResult();
    }

    private List<LinePath> computeBoundaryPaths() {
        InteriorAngleLinePathConnector.Minimize connector = new InteriorAngleLinePathConnector.Minimize();
        connector.connect(this.boundaries());
        return connector.connectAll().stream().map(LinePath::simplify).collect(Collectors.toList());
    }

    protected AbstractRegionBSPTree.RegionSizeProperties<Vector2D> computeRegionSizeProperties() {
        if (this.isFull()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(Double.POSITIVE_INFINITY, null);
        }
        if (this.isEmpty()) {
            return new AbstractRegionBSPTree.RegionSizeProperties(0.0, null);
        }
        double quadrilateralAreaSum = 0.0;
        double scaledSumX = 0.0;
        double scaledSumY = 0.0;
        for (LineConvexSubset boundary : this.boundaries()) {
            if (boundary.isInfinite()) {
                quadrilateralAreaSum = Double.POSITIVE_INFINITY;
                break;
            }
            Vector2D startPoint = boundary.getStartPoint();
            Vector2D endPoint = boundary.getEndPoint();
            double signedArea = startPoint.signedArea(endPoint);
            quadrilateralAreaSum += signedArea;
            scaledSumX += signedArea * (startPoint.getX() + endPoint.getX());
            scaledSumY += signedArea * (startPoint.getY() + endPoint.getY());
        }
        double size = Double.POSITIVE_INFINITY;
        Vector2D centroid = null;
        if (quadrilateralAreaSum >= 0.0 && Double.isFinite(quadrilateralAreaSum)) {
            size = 0.5 * quadrilateralAreaSum;
            if (quadrilateralAreaSum > 0.0) {
                centroid = Vector2D.of(scaledSumX, scaledSumY).multiply(1.0 / (3.0 * quadrilateralAreaSum));
            }
        }
        return new AbstractRegionBSPTree.RegionSizeProperties(size, centroid);
    }

    protected void invalidate() {
        super.invalidate();
        this.boundaryPaths = null;
    }

    protected RegionNode2D createNode() {
        return new RegionNode2D((AbstractBSPTree)this);
    }

    public static RegionBSPTree2D full() {
        return new RegionBSPTree2D(true);
    }

    public static RegionBSPTree2D empty() {
        return new RegionBSPTree2D(false);
    }

    public static RegionBSPTree2D from(Iterable<? extends LineConvexSubset> boundaries) {
        return RegionBSPTree2D.from(boundaries, false);
    }

    public static RegionBSPTree2D from(Iterable<? extends LineConvexSubset> boundaries, boolean full) {
        RegionBSPTree2D tree = new RegionBSPTree2D(full);
        tree.insert(boundaries);
        return tree;
    }

    public static PartitionedRegionBuilder2D partitionedRegionBuilder() {
        return new PartitionedRegionBuilder2D();
    }

    private static final class LinecastVisitor
    implements BSPTreeVisitor<Vector2D, RegionNode2D> {
        private final LineConvexSubset linecastSubset;
        private final boolean firstOnly;
        private double minAbscissa = Double.POSITIVE_INFINITY;
        private final List<LinecastPoint2D> results = new ArrayList<LinecastPoint2D>();

        LinecastVisitor(LineConvexSubset linecastSubset, boolean firstOnly) {
            this.linecastSubset = linecastSubset;
            this.firstOnly = firstOnly;
        }

        public LinecastPoint2D getFirstResult() {
            List<LinecastPoint2D> sortedResults = this.getResults();
            return sortedResults.isEmpty() ? null : sortedResults.get(0);
        }

        public List<LinecastPoint2D> getResults() {
            LinecastPoint2D.sortAndFilter(this.results);
            return this.results;
        }

        public BSPTreeVisitor.Order visitOrder(RegionNode2D internalNode) {
            Line cut = (Line)internalNode.getCutHyperplane();
            Line line = this.linecastSubset.getLine();
            boolean plusIsNear = line.getDirection().dot(cut.getOffsetDirection()) < 0.0;
            return plusIsNear ? BSPTreeVisitor.Order.PLUS_NODE_MINUS : BSPTreeVisitor.Order.MINUS_NODE_PLUS;
        }

        public BSPTreeVisitor.Result visit(RegionNode2D node) {
            if (node.isInternal()) {
                Line line = this.linecastSubset.getLine();
                Vector2D pt = ((Line)node.getCutHyperplane()).intersection(line);
                if (pt != null) {
                    LinecastPoint2D potentialResult;
                    if (this.firstOnly && !this.results.isEmpty() && line.getPrecision().compare(this.minAbscissa, line.abscissa(pt)) < 0) {
                        return BSPTreeVisitor.Result.TERMINATE;
                    }
                    if (this.linecastSubset.contains(pt) && (potentialResult = this.computeLinecastPoint(pt, node)) != null) {
                        this.results.add(potentialResult);
                        this.minAbscissa = Math.min(this.minAbscissa, potentialResult.getAbscissa());
                    }
                }
            }
            return BSPTreeVisitor.Result.CONTINUE;
        }

        private LinecastPoint2D computeLinecastPoint(Vector2D pt, RegionNode2D node) {
            Line cut = (Line)node.getCutHyperplane();
            RegionCutBoundary boundary = node.getCutBoundary();
            boolean onBoundary = false;
            boolean negateNormal = false;
            if (boundary.containsInsideFacing((Point)pt)) {
                onBoundary = true;
                negateNormal = true;
            } else if (boundary.containsOutsideFacing((Point)pt)) {
                onBoundary = true;
            }
            if (onBoundary) {
                Vector2D normal = cut.getOffsetDirection();
                if (negateNormal) {
                    normal = normal.negate();
                }
                return new LinecastPoint2D(pt, normal, this.linecastSubset.getLine());
            }
            return null;
        }
    }

    private static final class BoundaryProjector2D
    extends AbstractRegionBSPTree.BoundaryProjector<Vector2D, RegionNode2D> {
        BoundaryProjector2D(Vector2D point) {
            super((Point)point);
        }

        protected Vector2D disambiguateClosestPoint(Vector2D target, Vector2D a, Vector2D b) {
            int cmp = Vector2D.COORDINATE_ASCENDING_ORDER.compare(a, b);
            return cmp < 0 ? a : b;
        }
    }

    public static final class PartitionedRegionBuilder2D
    extends AbstractPartitionedRegionBuilder<Vector2D, RegionNode2D> {
        private PartitionedRegionBuilder2D() {
            super((AbstractRegionBSPTree)RegionBSPTree2D.empty());
        }

        public PartitionedRegionBuilder2D insertPartition(Line partition) {
            return this.insertPartition(partition.span());
        }

        public PartitionedRegionBuilder2D insertPartition(LineConvexSubset partition) {
            this.insertPartitionInternal(partition);
            return this;
        }

        public PartitionedRegionBuilder2D insertAxisAlignedPartitions(Vector2D center, Precision.DoubleEquivalence precision) {
            this.insertPartition(Lines.fromPointAndDirection(center, Vector2D.Unit.PLUS_X, precision));
            this.insertPartition(Lines.fromPointAndDirection(center, Vector2D.Unit.PLUS_Y, precision));
            return this;
        }

        public PartitionedRegionBuilder2D insertAxisAlignedGrid(Bounds2D bounds, int level, Precision.DoubleEquivalence precision) {
            this.insertAxisAlignedGridRecursive((Vector2D)bounds.getMin(), (Vector2D)bounds.getMax(), level, precision);
            return this;
        }

        private void insertAxisAlignedGridRecursive(Vector2D min, Vector2D max, int level, Precision.DoubleEquivalence precision) {
            if (level > 0) {
                Vector2D center = min.lerp(max, 0.5);
                this.insertAxisAlignedPartitions(center, precision);
                int nextLevel = level - 1;
                this.insertAxisAlignedGridRecursive(min, center, nextLevel, precision);
                this.insertAxisAlignedGridRecursive(center, max, nextLevel, precision);
            }
        }

        public PartitionedRegionBuilder2D insertBoundary(LineConvexSubset boundary) {
            this.insertBoundaryInternal(boundary);
            return this;
        }

        public PartitionedRegionBuilder2D insertBoundaries(Iterable<? extends LineConvexSubset> boundaries) {
            for (LineConvexSubset lineConvexSubset : boundaries) {
                this.insertBoundaryInternal(lineConvexSubset);
            }
            return this;
        }

        public PartitionedRegionBuilder2D insertBoundaries(BoundarySource2D boundarySrc) {
            try (Stream stream = boundarySrc.boundaryStream();){
                stream.forEach(arg_0 -> ((PartitionedRegionBuilder2D)this).insertBoundaryInternal(arg_0));
            }
            return this;
        }

        public RegionBSPTree2D build() {
            return (RegionBSPTree2D)this.buildInternal();
        }
    }

    public static final class RegionNode2D
    extends AbstractRegionBSPTree.AbstractRegionNode<Vector2D, RegionNode2D> {
        private RegionNode2D(AbstractBSPTree<Vector2D, RegionNode2D> tree) {
            super(tree);
        }

        public ConvexArea getNodeRegion() {
            RegionNode2D parent;
            ConvexArea area = ConvexArea.full();
            RegionNode2D child = this;
            while ((parent = (RegionNode2D)child.getParent()) != null) {
                Split<ConvexArea> split = area.split((Hyperplane<Vector2D>)parent.getCutHyperplane());
                area = child.isMinus() ? (ConvexArea)split.getMinus() : (ConvexArea)split.getPlus();
                child = parent;
            }
            return area;
        }

        protected RegionNode2D getSelf() {
            return this;
        }
    }
}

