/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;

public final class ReverseRay3D
extends LineConvexSubset3D {
    private final double end;

    ReverseRay3D(Line3D line, Vector3D endPoint) {
        this(line, line.abscissa(endPoint));
    }

    ReverseRay3D(Line3D line, double end) {
        super(line);
        this.end = end;
    }

    @Override
    public boolean isInfinite() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public double getSize() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Vector3D getStartPoint() {
        return null;
    }

    @Override
    public double getSubspaceStart() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Vector3D getEndPoint() {
        return this.getLine().toSpace(this.end);
    }

    @Override
    public double getSubspaceEnd() {
        return this.end;
    }

    @Override
    public Vector3D getCentroid() {
        return null;
    }

    @Override
    public Bounds3D getBounds() {
        return null;
    }

    @Override
    public ReverseRay3D transform(Transform<Vector3D> transform) {
        Line3D tLine = this.getLine().transform(transform);
        Vector3D tEnd = (Vector3D)transform.apply((Object)this.getEndPoint());
        return new ReverseRay3D(tLine, tEnd);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[direction= ").append(this.getLine().getDirection()).append(", endPoint= ").append(this.getEndPoint()).append(']');
        return sb.toString();
    }

    @Override
    boolean containsAbscissa(double abscissa) {
        return this.getLine().getPrecision().lte(abscissa, this.end);
    }
}

