/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;

public final class Ray3D
extends LineConvexSubset3D {
    private final double start;

    Ray3D(Line3D line, Vector3D startPoint) {
        this(line, line.abscissa(startPoint));
    }

    Ray3D(Line3D line, double start) {
        super(line);
        this.start = start;
    }

    @Override
    public boolean isInfinite() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public double getSize() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Vector3D getStartPoint() {
        return this.getLine().toSpace(this.start);
    }

    @Override
    public double getSubspaceStart() {
        return this.start;
    }

    @Override
    public Vector3D getEndPoint() {
        return null;
    }

    @Override
    public double getSubspaceEnd() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Vector3D getCentroid() {
        return null;
    }

    @Override
    public Bounds3D getBounds() {
        return null;
    }

    public Vector3D getDirection() {
        return this.getLine().getDirection();
    }

    @Override
    public Ray3D transform(Transform<Vector3D> transform) {
        Line3D tLine = this.getLine().transform(transform);
        Vector3D tStart = (Vector3D)transform.apply((Object)this.getStartPoint());
        return new Ray3D(tLine, tStart);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[startPoint= ").append(this.getStartPoint()).append(", direction= ").append(this.getLine().getDirection()).append(']');
        return sb.toString();
    }

    @Override
    boolean containsAbscissa(double abscissa) {
        return this.getLine().getPrecision().gte(abscissa, this.start);
    }
}

