/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineSubset3D;

public abstract class LineConvexSubset3D
extends LineSubset3D {
    LineConvexSubset3D(Line3D line) {
        super(line);
    }

    public abstract boolean isInfinite();

    public abstract boolean isFinite();

    public abstract Vector3D getStartPoint();

    public abstract double getSubspaceStart();

    public abstract Vector3D getEndPoint();

    public abstract double getSubspaceEnd();

    public abstract double getSize();

    public Interval getSubspaceRegion() {
        double start = this.getSubspaceStart();
        double end = this.getSubspaceEnd();
        return Interval.of(start, end, this.getLine().getPrecision());
    }

    public Interval getInterval() {
        return this.getSubspaceRegion();
    }

    public boolean contains(Vector3D pt) {
        Line3D line = this.getLine();
        return line.contains(pt) && this.containsAbscissa(line.abscissa(pt));
    }

    public abstract LineConvexSubset3D transform(Transform<Vector3D> var1);

    abstract boolean containsAbscissa(double var1);
}

