/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.geometry.euclidean.threed.Vector3D;

public final class EuclideanUtils {
    private EuclideanUtils() {
    }

    public static <T> List<T> convexPolygonToTriangleFan(List<Vector3D> vertices, Function<List<Vector3D>, T> fn) {
        int size = vertices.size();
        if (size < 3) {
            throw new IllegalArgumentException("Cannot create triangle fan: 3 or more vertices are required but found only " + vertices.size());
        }
        if (size == 3) {
            return Collections.singletonList(fn.apply(vertices));
        }
        ArrayList<T> triangles = new ArrayList<T>(size - 2);
        int fanIdx = EuclideanUtils.findBestTriangleFanIndex(vertices);
        int vertexIdx = (fanIdx + 1) % size;
        Vector3D fanBase = vertices.get(fanIdx);
        Vector3D vertexA = vertices.get(vertexIdx);
        vertexIdx = (vertexIdx + 1) % size;
        while (vertexIdx != fanIdx) {
            Vector3D vertexB = vertices.get(vertexIdx);
            triangles.add(fn.apply(Arrays.asList(fanBase, vertexA, vertexB)));
            vertexA = vertexB;
            vertexIdx = (vertexIdx + 1) % size;
        }
        return triangles;
    }

    private static int findBestTriangleFanIndex(List<Vector3D> vertices) {
        double dot;
        Vector3D.Unit lastVec;
        Iterator<Vector3D> it = vertices.iterator();
        Vector3D curPt = it.next();
        Vector3D.Unit incomingVec = lastVec = vertices.get(vertices.size() - 1).directionTo(curPt);
        int bestIdx = 0;
        double bestDot = -1.0;
        int idx = 0;
        while (it.hasNext()) {
            Vector3D nextPt = it.next();
            Vector3D.Unit outgoingVec = curPt.directionTo(nextPt);
            dot = incomingVec.dot(outgoingVec);
            if (dot > bestDot) {
                bestIdx = idx;
                bestDot = dot;
            }
            curPt = nextPt;
            incomingVec = outgoingVec;
            ++idx;
        }
        dot = incomingVec.dot(lastVec);
        if (dot > bestDot) {
            bestIdx = idx;
        }
        return bestIdx;
    }
}

