/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv271Test {
    @Test
    public void testJiraCsv271_withArray() throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)stringWriter, csvFormat);){
            printer.print((Object)"a");
            printer.printRecord(new Object[]{"b", "c"});
        }
        Assertions.assertEquals((Object)"a,b,c\r\n", (Object)stringWriter.toString());
    }

    @Test
    public void testJiraCsv271_withList() throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)stringWriter, csvFormat);){
            printer.print((Object)"a");
            printer.printRecord(Arrays.asList("b", "c"));
        }
        Assertions.assertEquals((Object)"a,b,c\r\n", (Object)stringWriter.toString());
    }
}

