/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv249Test {
    @Test
    public void testJiraCsv249() throws IOException {
        List records;
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setEscape('\\').build();
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)stringWriter, csvFormat);){
            printer.printRecord(new Object[]{"foo \\", "bar"});
        }
        StringReader stringReader = new StringReader(stringWriter.toString());
        try (CSVParser parser = new CSVParser((Reader)stringReader, csvFormat);){
            records = parser.getRecords();
        }
        records.forEach(record -> {
            Assertions.assertEquals((Object)"foo \\", (Object)record.get(0));
            Assertions.assertEquals((Object)"bar", (Object)record.get(1));
        });
    }
}

