/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv248Test {
    private static InputStream getTestInput() {
        return ClassLoader.getSystemClassLoader().getResourceAsStream("org/apache/commons/csv/CSV-248/csvRecord.bin");
    }

    @Test
    public void testJiraCsv248() throws IOException, ClassNotFoundException {
        try (InputStream in = JiraCsv248Test.getTestInput();
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object object = ois.readObject();
            Assertions.assertTrue((boolean)(object instanceof CSVRecord));
            CSVRecord rec = (CSVRecord)object;
            Assertions.assertEquals((long)1L, (long)rec.getRecordNumber());
            Assertions.assertEquals((Object)"One", (Object)rec.get(0));
            Assertions.assertEquals((Object)"Two", (Object)rec.get(1));
            Assertions.assertEquals((int)2, (int)rec.size());
            Assertions.assertEquals((long)4L, (long)rec.getCharacterPosition());
            Assertions.assertEquals((Object)"my comment", (Object)rec.getComment());
            Assertions.assertNull((Object)rec.getParser());
            Assertions.assertTrue((boolean)rec.isConsistent());
            Assertions.assertFalse((boolean)rec.isMapped("A"));
            Assertions.assertFalse((boolean)rec.isSet("A"));
            Assertions.assertEquals((int)0, (int)rec.toMap().size());
            try {
                rec.get("A");
                Assertions.fail((String)"Access by name is not expected after deserialisation");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

