/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv198Test {
    private static final CSVFormat CSV_FORMAT = CSVFormat.EXCEL.builder().setDelimiter('^').setHeader(new String[0]).setSkipHeaderRecord(true).build();

    @Test
    public void test() throws UnsupportedEncodingException, IOException {
        InputStream pointsOfReference = this.getClass().getResourceAsStream("/org/apache/commons/csv/CSV-198/optd_por_public.csv");
        Assertions.assertNotNull((Object)pointsOfReference);
        try (CSVParser parser = CSV_FORMAT.parse((Reader)new InputStreamReader(pointsOfReference, StandardCharsets.UTF_8));){
            for (CSVRecord record : parser) {
                String locationType = record.get("location_type");
                Assertions.assertNotNull((Object)locationType);
            }
        }
    }
}

