/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv294Test {
    private static void testInternal(CSVFormat csvFormat, String expectedSubstring) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8), csvFormat);){
            printer.printRecord(new Object[]{"a", "b \"\"", "c"});
        }
        byte[] written = bos.toByteArray();
        String writtenString = new String(written, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)writtenString.contains(expectedSubstring));
        try (CSVParser parser = new CSVParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(written), StandardCharsets.UTF_8), csvFormat);){
            List records = parser.getRecords();
            Assertions.assertEquals((int)1, (int)records.size());
            CSVRecord record = (CSVRecord)records.get(0);
            Assertions.assertEquals((Object)"a", (Object)record.get(0));
            Assertions.assertEquals((Object)"b \"\"", (Object)record.get(1));
            Assertions.assertEquals((Object)"c", (Object)record.get(2));
        }
    }

    @Test
    public void testDefaultCsvFormatWithBackslashEscapeWorks() throws IOException {
        JiraCsv294Test.testInternal(CSVFormat.Builder.create().setEscape('\\').build(), ",\"b \\\"\\\"\",");
    }

    @Test
    public void testDefaultCsvFormatWithNullEscapeWorks() throws IOException {
        JiraCsv294Test.testInternal(CSVFormat.Builder.create().setEscape(null).build(), ",\"b \"\"\"\"\",");
    }

    @Test
    public void testDefaultCsvFormatWithQuoteEscapeWorks() throws IOException {
        JiraCsv294Test.testInternal(CSVFormat.Builder.create().setEscape('\"').build(), ",\"b \"\"\"\"\",");
    }

    @Test
    public void testDefaultCsvFormatWorks() throws IOException {
        JiraCsv294Test.testInternal(CSVFormat.Builder.create().build(), ",\"b \"\"\"\"\",");
    }
}

