/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv288Test {
    private void print(CSVRecord csvRecord, CSVPrinter csvPrinter) throws IOException {
        for (String value : csvRecord) {
            csvPrinter.print((Object)value);
        }
    }

    @Test
    public void testParseWithABADelimiter() throws Exception {
        StringReader in = new StringReader("a|~|b|~|c|~|d|~||~|f");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser parser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("|~|").build());){
            for (CSVRecord csvRecord : parser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithDoublePipeDelimiter() throws Exception {
        StringReader in = new StringReader("a||b||c||d||||f");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("||").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithDoublePipeDelimiterDoubleCharValue() throws Exception {
        StringReader in = new StringReader("a||bb||cc||dd||f");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("||").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,bb,cc,dd,f", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithDoublePipeDelimiterEndsWithDelimiter() throws Exception {
        StringReader in = new StringReader("a||b||c||d||||f||");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("||").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f,", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithDoublePipeDelimiterQuoted() throws Exception {
        StringReader in = new StringReader("a||\"b||c\"||d||||f");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("||").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b||c,d,,f", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithSinglePipeDelimiterEndsWithDelimiter() throws Exception {
        StringReader in = new StringReader("a|b|c|d||f|");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("|").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f,", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithTriplePipeDelimiter() throws Exception {
        StringReader in = new StringReader("a|||b|||c|||d||||||f");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("|||").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithTwoCharDelimiter1() throws Exception {
        StringReader in = new StringReader("a~|b~|c~|d~|~|f");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("~|").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithTwoCharDelimiter2() throws Exception {
        StringReader in = new StringReader("a~|b~|c~|d~|~|f~");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("~|").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f~", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithTwoCharDelimiter3() throws Exception {
        StringReader in = new StringReader("a~|b~|c~|d~|~|f|");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("~|").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f|", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithTwoCharDelimiter4() throws Exception {
        StringReader in = new StringReader("a~|b~|c~|d~|~|f~~||g");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("~|").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f~,|g", (Object)stringBuilder.toString());
            }
        }
    }

    @Test
    public void testParseWithTwoCharDelimiterEndsWithDelimiter() throws Exception {
        StringReader in = new StringReader("a~|b~|c~|d~|~|f~|");
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilder, CSVFormat.EXCEL);
             CSVParser csvParser = CSVParser.parse((Reader)in, (CSVFormat)CSVFormat.Builder.create().setDelimiter("~|").build());){
            for (CSVRecord csvRecord : csvParser) {
                this.print(csvRecord, csvPrinter);
                Assertions.assertEquals((Object)"a,b,c,d,,f,", (Object)stringBuilder.toString());
            }
        }
    }
}

