/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv265Test {
    @Test
    public void testCharacterPositionWithComments() throws IOException {
        String csv = "# Comment1\nHeader1,Header2\n# Comment2\nValue1,Value2\n# Comment3\nValue3,Value4\n# Comment4\n";
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setCommentMarker('#').setHeader(new String[0]).setSkipHeaderRecord(true).build();
        try (CSVParser parser = csvFormat.parse((Reader)new StringReader("# Comment1\nHeader1,Header2\n# Comment2\nValue1,Value2\n# Comment3\nValue3,Value4\n# Comment4\n"));){
            Iterator itr = parser.iterator();
            CSVRecord record1 = (CSVRecord)itr.next();
            Assertions.assertEquals((long)"# Comment1\nHeader1,Header2\n# Comment2\nValue1,Value2\n# Comment3\nValue3,Value4\n# Comment4\n".indexOf("# Comment2"), (long)record1.getCharacterPosition());
            CSVRecord record2 = (CSVRecord)itr.next();
            Assertions.assertEquals((long)"# Comment1\nHeader1,Header2\n# Comment2\nValue1,Value2\n# Comment3\nValue3,Value4\n# Comment4\n".indexOf("# Comment3"), (long)record2.getCharacterPosition());
        }
    }

    @Test
    public void testCharacterPositionWithCommentsSpanningMultipleLines() throws IOException {
        String csv = "# Comment1\n# Comment2\nHeader1,Header2\n# Comment3\n# Comment4\nValue1,Value2\n# Comment5\n# Comment6\nValue3,Value4";
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setCommentMarker('#').setHeader(new String[0]).setSkipHeaderRecord(true).build();
        try (CSVParser parser = csvFormat.parse((Reader)new StringReader("# Comment1\n# Comment2\nHeader1,Header2\n# Comment3\n# Comment4\nValue1,Value2\n# Comment5\n# Comment6\nValue3,Value4"));){
            Iterator itr = parser.iterator();
            CSVRecord record1 = (CSVRecord)itr.next();
            Assertions.assertEquals((long)"# Comment1\n# Comment2\nHeader1,Header2\n# Comment3\n# Comment4\nValue1,Value2\n# Comment5\n# Comment6\nValue3,Value4".indexOf("# Comment3"), (long)record1.getCharacterPosition());
            CSVRecord record2 = (CSVRecord)itr.next();
            Assertions.assertEquals((long)"# Comment1\n# Comment2\nHeader1,Header2\n# Comment3\n# Comment4\nValue1,Value2\n# Comment5\n# Comment6\nValue3,Value4".indexOf("# Comment5"), (long)record2.getCharacterPosition());
        }
    }
}

