/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv150Test {
    private void testDisable(CSVFormat csvFormat, StringReader stringReader) throws IOException {
        try (CSVParser csvParser = new CSVParser((Reader)stringReader, csvFormat);){
            Assertions.assertEquals((int)1, (int)csvParser.getRecords().size());
        }
    }

    @Test
    public void testDisableComment() throws IOException {
        StringReader stringReader = new StringReader("\"66\u2441\",,\"\",\"DeutscheBK\ufffe\",\"000\"\r\n");
        this.testDisable(CSVFormat.DEFAULT.builder().setCommentMarker(null).build(), stringReader);
    }

    @Test
    public void testDisableEncapsulation() throws IOException {
        StringReader stringReader = new StringReader("66\u2441,,\"\",\ufffeDeutscheBK,\"000\"\r\n");
        this.testDisable(CSVFormat.DEFAULT.builder().setQuote(null).build(), stringReader);
    }

    @Test
    public void testDisableEscaping() throws IOException {
        StringReader stringReader = new StringReader("\"66\u2441\",,\"\",\"DeutscheBK\ufffe\",\"000\"\r\n");
        this.testDisable(CSVFormat.DEFAULT.builder().setEscape(null).build(), stringReader);
    }
}

