/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import org.apache.commons.csv.Token;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.AllOf;

final class TokenMatchers {
    TokenMatchers() {
    }

    public static Matcher<Token> hasContent(final String expectedContent) {
        return new TypeSafeDiagnosingMatcher<Token>(){

            public void describeTo(Description description) {
                description.appendText("token has content ");
                description.appendValue((Object)expectedContent);
            }

            protected boolean matchesSafely(Token item, Description mismatchDescription) {
                mismatchDescription.appendText("token content is ");
                mismatchDescription.appendValue((Object)item.content.toString());
                return expectedContent.equals(item.content.toString());
            }
        };
    }

    public static Matcher<Token> hasType(final Token.Type expectedType) {
        return new TypeSafeDiagnosingMatcher<Token>(){

            public void describeTo(Description description) {
                description.appendText("token has type ");
                description.appendValue((Object)expectedType);
            }

            protected boolean matchesSafely(Token item, Description mismatchDescription) {
                mismatchDescription.appendText("token type is ");
                mismatchDescription.appendValue((Object)item.type);
                return item.type == expectedType;
            }
        };
    }

    public static Matcher<Token> isReady() {
        return new TypeSafeDiagnosingMatcher<Token>(){

            public void describeTo(Description description) {
                description.appendText("token is ready ");
            }

            protected boolean matchesSafely(Token item, Description mismatchDescription) {
                mismatchDescription.appendText("token is not ready ");
                return item.isReady;
            }
        };
    }

    public static Matcher<Token> matches(Token.Type expectedType, String expectedContent) {
        return AllOf.allOf((Matcher[])new Matcher[]{TokenMatchers.hasType(expectedType), TokenMatchers.hasContent(expectedContent)});
    }
}

