/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.util.BitSet;
import org.apache.commons.compress.MemoryLimitException;

final class SubStreamsInfo {
    final long[] unpackSizes;
    final BitSet hasCrc;
    final long[] crcs;

    SubStreamsInfo(long totalUnpackStreams, int maxMemoryLimitKiB) throws MemoryLimitException {
        int intExact = Math.toIntExact(totalUnpackStreams);
        int request = intExact * 3;
        if (request > maxMemoryLimitKiB) {
            throw new MemoryLimitException((long)request, maxMemoryLimitKiB);
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        if ((long)request > freeMemory) {
            throw new MemoryLimitException((long)request, freeMemory);
        }
        this.unpackSizes = new long[intExact];
        this.hasCrc = new BitSet(intExact);
        this.crcs = new long[intExact];
    }
}

