/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.AbstractCoder;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.lang3.ArrayUtils;
import org.tukaani.xz.DeltaOptions;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.FinishableWrapperOutputStream;

final class DeltaDecoder
extends AbstractCoder {
    DeltaDecoder() {
        super(Number.class);
    }

    @Override
    InputStream decode(String archiveName, InputStream in, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitKiB) throws IOException {
        return new DeltaOptions(this.getOptionsFromCoder(coder)).getInputStream(in);
    }

    @Override
    OutputStream encode(OutputStream out, Object options) throws IOException {
        return new DeltaOptions(DeltaDecoder.toInt(options, 1)).getOutputStream((FinishableOutputStream)new FinishableWrapperOutputStream(out));
    }

    @Override
    byte[] getOptionsAsProperties(Object options) {
        return new byte[]{(byte)(DeltaDecoder.toInt(options, 1) - 1)};
    }

    private int getOptionsFromCoder(Coder coder) {
        if (coder == null || ArrayUtils.isEmpty((byte[])coder.properties)) {
            return 1;
        }
        return (0xFF & coder.properties[0]) + 1;
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream in) {
        return this.getOptionsFromCoder(coder);
    }
}

