/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;

public class FileNameUtils {
    private static String fileNameToBaseName(String name) {
        int extensionIndex = name.lastIndexOf(46);
        return extensionIndex < 0 ? name : name.substring(0, extensionIndex);
    }

    public static String getBaseName(Path path) {
        if (path == null) {
            return null;
        }
        Path fileName = path.getFileName();
        return fileName != null ? FileNameUtils.fileNameToBaseName(fileName.toString()) : null;
    }

    public static String getBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        return FileNameUtils.fileNameToBaseName(new File(fileName).getName());
    }

    public static String getExtension(Path path) {
        if (path == null) {
            return null;
        }
        Path fileName = path.getFileName();
        return fileName != null ? FilenameUtils.getExtension((String)fileName.toString()) : null;
    }

    public static String getExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }
}

