/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilterProducer;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;
import org.apache.commons.collections4.bloomfilter.LayerManager;
import org.apache.commons.collections4.bloomfilter.SetOperations;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;

public class LayeredBloomFilter
implements BloomFilter,
BloomFilterProducer {
    private final Shape shape;
    private LayerManager layerManager;

    public static LayeredBloomFilter fixed(Shape shape, int maxDepth) {
        LayerManager manager = LayerManager.builder().setExtendCheck(LayerManager.ExtendCheck.advanceOnPopulated()).setCleanup(LayerManager.Cleanup.onMaxSize(maxDepth)).setSupplier(() -> new SimpleBloomFilter(shape)).build();
        return new LayeredBloomFilter(shape, manager);
    }

    public LayeredBloomFilter(Shape shape, LayerManager layerManager) {
        this.shape = shape;
        this.layerManager = layerManager;
    }

    @Override
    public int cardinality() {
        return SetOperations.cardinality(this);
    }

    @Override
    public int characteristics() {
        return 0;
    }

    @Override
    public final void clear() {
        this.layerManager.clear();
    }

    @Override
    public boolean contains(BitMapProducer bitMapProducer) {
        return this.contains(this.createFilter(bitMapProducer));
    }

    @Override
    public boolean contains(BloomFilter other) {
        return other instanceof BloomFilterProducer ? this.contains((BloomFilterProducer)((Object)other)) : !this.forEachBloomFilter(x -> !x.contains(other));
    }

    public boolean contains(BloomFilterProducer producer) {
        boolean[] result = new boolean[]{true};
        return producer.forEachBloomFilter(x -> {
            result[0] = result[0] & this.contains((BloomFilter)x);
            return result[0];
        });
    }

    @Override
    public boolean contains(Hasher hasher) {
        return this.contains(this.createFilter(hasher));
    }

    @Override
    public boolean contains(IndexProducer indexProducer) {
        return this.contains(this.createFilter(indexProducer));
    }

    @Override
    public LayeredBloomFilter copy() {
        return new LayeredBloomFilter(this.shape, this.layerManager.copy());
    }

    private BloomFilter createFilter(BitMapProducer bitMapProducer) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(bitMapProducer);
        return bf;
    }

    private BloomFilter createFilter(Hasher hasher) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(hasher);
        return bf;
    }

    private BloomFilter createFilter(IndexProducer indexProducer) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(indexProducer);
        return bf;
    }

    @Override
    public int estimateN() {
        return this.flatten().estimateN();
    }

    @Override
    public int estimateUnion(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        BloomFilter cpy = this.flatten();
        cpy.merge(other);
        return cpy.estimateN();
    }

    public int[] find(BitMapProducer bitMapProducer) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(bitMapProducer);
        return this.find(bf);
    }

    public int[] find(BloomFilter bf) {
        Finder finder = new Finder(bf);
        this.forEachBloomFilter(finder);
        return finder.getResult();
    }

    public int[] find(Hasher hasher) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(hasher);
        return this.find(bf);
    }

    public int[] find(IndexProducer indexProducer) {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        bf.merge(indexProducer);
        return this.find(bf);
    }

    @Override
    public BloomFilter flatten() {
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        this.forEachBloomFilter(bf::merge);
        return bf;
    }

    @Override
    public boolean forEachBitMap(LongPredicate predicate) {
        return this.flatten().forEachBitMap(predicate);
    }

    @Override
    public final boolean forEachBloomFilter(Predicate<BloomFilter> bloomFilterPredicate) {
        return this.layerManager.forEachBloomFilter(bloomFilterPredicate);
    }

    @Override
    public boolean forEachIndex(IntPredicate predicate) {
        return this.forEachBloomFilter(bf -> bf.forEachIndex(predicate));
    }

    public BloomFilter get(int depth) {
        return this.layerManager.get(depth);
    }

    public final int getDepth() {
        return this.layerManager.getDepth();
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean isEmpty() {
        return this.forEachBloomFilter(BloomFilter::isEmpty);
    }

    @Override
    public boolean merge(BitMapProducer bitMapProducer) {
        return this.layerManager.getTarget().merge(bitMapProducer);
    }

    @Override
    public boolean merge(BloomFilter bf) {
        return this.layerManager.getTarget().merge(bf);
    }

    @Override
    public boolean merge(IndexProducer indexProducer) {
        return this.layerManager.getTarget().merge(indexProducer);
    }

    public void next() {
        this.layerManager.next();
    }

    public void cleanup() {
        this.layerManager.cleanup();
    }

    private class Finder
    implements Predicate<BloomFilter> {
        int[] result;
        int bfIdx;
        int resultIdx;
        BloomFilter bf;

        Finder(BloomFilter bf) {
            this.result = new int[LayeredBloomFilter.this.layerManager.getDepth()];
            this.bf = bf;
        }

        int[] getResult() {
            return Arrays.copyOf(this.result, this.resultIdx);
        }

        @Override
        public boolean test(BloomFilter x) {
            if (x.contains(this.bf)) {
                this.result[this.resultIdx++] = this.bfIdx;
            }
            ++this.bfIdx;
            return true;
        }
    }
}

