/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilterProducer;

public class LayerManager
implements BloomFilterProducer {
    private final LinkedList<BloomFilter> filters = new LinkedList();
    private final Consumer<LinkedList<BloomFilter>> filterCleanup;
    private final Predicate<LayerManager> extendCheck;
    private final Supplier<BloomFilter> filterSupplier;

    public static Builder builder() {
        return new Builder();
    }

    private LayerManager(Supplier<BloomFilter> filterSupplier, Predicate<LayerManager> extendCheck, Consumer<LinkedList<BloomFilter>> filterCleanup, boolean initialize) {
        this.filterSupplier = filterSupplier;
        this.extendCheck = extendCheck;
        this.filterCleanup = filterCleanup;
        if (initialize) {
            this.addFilter();
        }
    }

    private void addFilter() {
        BloomFilter bf = this.filterSupplier.get();
        if (bf == null) {
            throw new NullPointerException("filterSupplier returned null.");
        }
        this.filters.add(bf);
    }

    public final void clear() {
        this.filters.clear();
        this.addFilter();
    }

    public LayerManager copy() {
        LayerManager newMgr = new LayerManager(this.filterSupplier, this.extendCheck, this.filterCleanup, false);
        for (BloomFilter bf : this.filters) {
            newMgr.filters.add(bf.copy());
        }
        return newMgr;
    }

    @Override
    public boolean forEachBloomFilter(Predicate<BloomFilter> bloomFilterPredicate) {
        for (BloomFilter bf : this.filters) {
            if (bloomFilterPredicate.test(bf)) continue;
            return false;
        }
        return true;
    }

    public final BloomFilter get(int depth) {
        if (depth < 0 || depth >= this.filters.size()) {
            throw new NoSuchElementException(String.format("Depth must be in the range [0,%s)", this.filters.size()));
        }
        return this.filters.get(depth);
    }

    public final int getDepth() {
        return this.filters.size();
    }

    public final BloomFilter getTarget() {
        if (this.extendCheck.test(this)) {
            this.next();
        }
        return this.filters.peekLast();
    }

    void next() {
        this.filterCleanup.accept(this.filters);
        this.addFilter();
    }

    void cleanup() {
        this.filterCleanup.accept(this.filters);
        if (this.filters.isEmpty()) {
            this.addFilter();
        }
    }

    public static class Builder {
        private Predicate<LayerManager> extendCheck = ExtendCheck.neverAdvance();
        private Supplier<BloomFilter> supplier;
        private Consumer<LinkedList<BloomFilter>> cleanup = Cleanup.noCleanup();

        private Builder() {
        }

        public LayerManager build() {
            Objects.requireNonNull(this.supplier, "Supplier must not be null");
            Objects.requireNonNull(this.extendCheck, "ExtendCheck must not be null");
            Objects.requireNonNull(this.cleanup, "Cleanup must not be null");
            return new LayerManager(this.supplier, this.extendCheck, this.cleanup, true);
        }

        public Builder setCleanup(Consumer<LinkedList<BloomFilter>> cleanup) {
            this.cleanup = cleanup;
            return this;
        }

        public Builder setExtendCheck(Predicate<LayerManager> extendCheck) {
            this.extendCheck = extendCheck;
            return this;
        }

        public Builder setSupplier(Supplier<BloomFilter> supplier) {
            this.supplier = supplier;
            return this;
        }
    }

    public static final class ExtendCheck {
        public static Predicate<LayerManager> advanceOnCount(final int breakAt) {
            if (breakAt <= 0) {
                throw new IllegalArgumentException("'breakAt' must be greater than 0");
            }
            return new Predicate<LayerManager>(){
                int count;

                @Override
                public boolean test(LayerManager filter) {
                    return ++this.count % breakAt == 0;
                }
            };
        }

        public static Predicate<LayerManager> advanceOnPopulated() {
            return lm -> !((BloomFilter)((LayerManager)lm).filters.peekLast()).isEmpty();
        }

        public static Predicate<LayerManager> advanceOnSaturation(double maxN) {
            if (maxN <= 0.0) {
                throw new IllegalArgumentException("'maxN' must be greater than 0");
            }
            return manager -> {
                BloomFilter bf = (BloomFilter)((LayerManager)manager).filters.peekLast();
                return maxN <= bf.getShape().estimateN(bf.cardinality());
            };
        }

        public static Predicate<LayerManager> neverAdvance() {
            return x -> false;
        }

        private ExtendCheck() {
        }
    }

    public static final class Cleanup {
        public static Consumer<LinkedList<BloomFilter>> noCleanup() {
            return x -> {};
        }

        public static Consumer<LinkedList<BloomFilter>> onMaxSize(int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("'maxSize' must be greater than 0");
            }
            return ll -> {
                while (ll.size() > maxSize) {
                    ll.removeFirst();
                }
            };
        }

        public static Consumer<LinkedList<BloomFilter>> removeEmptyTarget() {
            return x -> {
                if (((BloomFilter)x.getLast()).cardinality() == 0) {
                    x.removeLast();
                }
            };
        }

        private Cleanup() {
        }
    }
}

