/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final ReferenceType DEFAULT_KEY_TYPE = ReferenceType.WEAK;
    static final ReferenceType DEFAULT_VALUE_TYPE = ReferenceType.STRONG;
    static final EnumSet<Option> DEFAULT_OPTIONS = null;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int RETRIES_BEFORE_LOCK = 2;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment<K, V>[] segments;
    private final boolean identityComparisons;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Collection<V> values;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private ConcurrentReferenceHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ReferenceType keyType, ReferenceType valueType, EnumSet<Option> options) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        this.identityComparisons = options != null && options.contains((Object)Option.IDENTITY_COMPARISONS);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor, keyType, valueType, this.identityComparisons);
        }
    }

    @Override
    public void clear() {
        for (Segment<K, V> segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        int hash = this.hashOf(key);
        Segment<? super K, ? extends V> segment = this.segmentFor(hash);
        return segment.apply((K)key, hash, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mappingFunction);
        int hash = this.hashOf(key);
        Segment<? super K, ? extends V> segment = this.segmentFor(hash);
        V v = segment.get(key, hash);
        return v == null ? segment.put((K)key, hash, (V)null, mappingFunction, true) : v;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        int hash = this.hashOf(key);
        Segment<K, V> segment = this.segmentFor(hash);
        V v = segment.get(key, hash);
        if (v == null) {
            return null;
        }
        return this.segmentFor(hash).applyIfPresent((K)key, hash, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = this.hashOf(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i = 0; i < segments.length; ++i) {
                mc[i] = ((Segment)segments[i]).modCount;
                mcsum += mc[i];
                if (!segments[i].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments.length; ++i) {
                    if (mc[i] == ((Segment)segments[i]).modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment<K, V> segment : segments) {
            segment.lock();
        }
        boolean found = false;
        try {
            for (Segment<K, V> segment : segments) {
                if (!segment.containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (Segment<K, V> segment : segments) {
                segment.unlock();
            }
        }
        return found;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(false));
    }

    @Override
    public V get(Object key) {
        int hash = this.hashOf(key);
        return this.segmentFor(hash).get(key, hash);
    }

    private int hashOf(Object key) {
        return ConcurrentReferenceHashMap.hash(this.identityComparisons ? System.identityHashCode(key) : key.hashCode());
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment<K, V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (((Segment)segments[i]).count != 0) {
                return false;
            }
            mc[i] = ((Segment)segments[i]).modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (((Segment)segments[i]).count == 0 && mc[i] == ((Segment)segments[i]).modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public void purgeStaleEntries() {
        for (Segment<K, V> segment : this.segments) {
            segment.removeStale();
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int hash = this.hashOf(key);
        return this.segmentFor(hash).put(key, hash, value, null, false);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.hashOf(key);
        return this.segmentFor(hash).put(key, hash, value, null, true);
    }

    @Override
    public V remove(Object key) {
        int hash = this.hashOf(key);
        return this.segmentFor(hash).remove(key, hash, null, false);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = this.hashOf(key);
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value, false) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = this.hashOf(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = this.hashOf(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    private Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)((Segment)segments[i]).count;
                mc[i] = ((Segment)segments[i]).modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)((Segment)segments[i]).count;
                    if (mc[i] == ((Segment)segments[i]).modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment<K, V> segment : segments) {
                segment.lock();
            }
            for (Segment<K, V> segment : segments) {
                sum += (long)((Segment)segment).count;
            }
            for (Segment<K, V> segment : segments) {
                segment.unlock();
            }
        }
        return sum > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sum;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    private static final class Segment<K, V>
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;
        private volatile transient int count;
        private transient int modCount;
        private transient int threshold;
        private volatile transient HashEntry<K, V>[] table;
        private final float loadFactor;
        private volatile transient ReferenceQueue<Object> refQueue;
        private final ReferenceType keyType;
        private final ReferenceType valueType;
        private final boolean identityComparisons;

        static <K, V> Segment<K, V>[] newArray(int i) {
            return new Segment[i];
        }

        Segment(int initialCapacity, float loadFactor, ReferenceType keyType, ReferenceType valueType, boolean identityComparisons) {
            this.loadFactor = loadFactor;
            this.keyType = keyType;
            this.valueType = valueType;
            this.identityComparisons = identityComparisons;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V apply(K key, int hash, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            this.lock();
            try {
                V oldValue = this.get(key, hash);
                V newValue = remappingFunction.apply(key, oldValue);
                if (newValue == null) {
                    if (oldValue != null) {
                        this.removeInternal(key, hash, oldValue, false);
                    }
                    V v = null;
                    return v;
                }
                this.putInternal(key, hash, newValue, null, false);
                V v = newValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V applyIfPresent(K key, int hash, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            this.lock();
            try {
                V oldValue = this.get(key, hash);
                if (oldValue == null) {
                    V v = null;
                    return v;
                }
                V newValue = remappingFunction.apply(key, oldValue);
                if (newValue == null) {
                    this.removeInternal(key, hash, oldValue, false);
                    V v = null;
                    return v;
                }
                this.putInternal(key, hash, newValue, null, false);
                V v = newValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    Object[] tab = this.table;
                    Arrays.fill(tab, null);
                    ++this.modCount;
                    this.refQueue = new ReferenceQueue();
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && this.keyEq(key, e.key())) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsValue(Object value) {
            if (this.count != 0) {
                for (HashEntry<K, V> hashEntry : this.table) {
                    void var5_5;
                    while (var5_5 != null) {
                        Object opaque = ((HashEntry)var5_5).valueRef;
                        V v = opaque == null ? this.readValueUnderLock((HashEntry<K, V>)var5_5) : var5_5.dereferenceValue(opaque);
                        if (value.equals(v)) {
                            return true;
                        }
                        HashEntry hashEntry2 = ((HashEntry)var5_5).next;
                    }
                }
            }
            return false;
        }

        V get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && this.keyEq(key, e.key())) {
                        Object opaque = e.valueRef;
                        if (opaque != null) {
                            return e.dereferenceValue(opaque);
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        HashEntry<K, V> getFirst(int hash) {
            HashEntry<K, V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        V getValue(K key, V value, Function<? super K, ? extends V> function) {
            return value != null ? value : function.apply(key);
        }

        private boolean keyEq(Object src, Object dest) {
            return this.identityComparisons ? src == dest : src.equals(dest);
        }

        HashEntry<K, V> newHashEntry(K key, int hash, HashEntry<K, V> next, V value) {
            return new HashEntry<K, V>(key, hash, next, value, this.keyType, this.valueType, this.refQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, Function<? super K, ? extends V> function, boolean onlyIfAbsent) {
            this.lock();
            try {
                V v = this.putInternal(key, hash, value, function, onlyIfAbsent);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private V putInternal(K key, int hash, V value, Function<? super K, ? extends V> function, boolean onlyIfAbsent) {
            V resultValue;
            HashEntry first;
            int reduced;
            this.removeStale();
            int c = this.count;
            if (c++ > this.threshold && (reduced = this.rehash()) > 0) {
                this.count = (c -= reduced) - 1;
            }
            HashEntry<K, V>[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && this.keyEq(key, e.key()))) {
                e = e.next;
            }
            if (e != null) {
                resultValue = e.value();
                if (!onlyIfAbsent) {
                    e.setValue(this.getValue(key, value, function), this.valueType, this.refQueue);
                }
            } else {
                V v = this.getValue(key, value, function);
                Object object = resultValue = function != null ? v : null;
                if (v != null) {
                    ++this.modCount;
                    tab[index] = this.newHashEntry(key, hash, first, v);
                    this.count = c;
                }
            }
            return resultValue;
        }

        V readValueUnderLock(HashEntry<K, V> e) {
            this.lock();
            try {
                this.removeStale();
                V v = e.value();
                return v;
            }
            finally {
                this.unlock();
            }
        }

        int rehash() {
            HashEntry<K, V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return 0;
            }
            HashEntry<K, V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            int reduce = 0;
            for (int i = 0; i < oldCapacity; ++i) {
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    int k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    K key = p.key();
                    if (key == null) {
                        ++reduce;
                    } else {
                        int k = p.hash & sizeMask;
                        HashEntry n = newTable[k];
                        newTable[k] = this.newHashEntry(key, p.hash, n, p.value());
                    }
                    p = p.next;
                }
            }
            this.table = newTable;
            return reduce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, Object value, boolean refRemove) {
            this.lock();
            try {
                V v = this.removeInternal(key, hash, value, refRemove);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private V removeInternal(Object key, int hash, Object value, boolean refRemove) {
            HashEntry first;
            if (!refRemove) {
                this.removeStale();
            }
            int c = this.count - 1;
            HashEntry<K, V>[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (e != null && key != e.keyRef && (refRemove || hash != e.hash || !this.keyEq(key, e.key()))) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                V v = e.value();
                if (value == null || value.equals(v)) {
                    oldValue = v;
                    ++this.modCount;
                    HashEntry newFirst = e.next;
                    HashEntry p = first;
                    while (p != e) {
                        Object pKey = p.key();
                        if (pKey == null) {
                            --c;
                        } else {
                            newFirst = this.newHashEntry(pKey, p.hash, newFirst, p.value());
                        }
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    this.count = c;
                }
            }
            return oldValue;
        }

        void removeStale() {
            KeyReference ref;
            while ((ref = (KeyReference)((Object)this.refQueue.poll())) != null) {
                this.remove(ref.keyRef(), ref.keyHash(), null, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            this.lock();
            try {
                V v = this.replaceInternal(key, hash, newValue);
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                boolean bl = this.replaceInternal2(key, hash, oldValue, newValue);
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        private V replaceInternal(K key, int hash, V newValue) {
            this.removeStale();
            HashEntry e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && this.keyEq(key, e.key()))) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                oldValue = e.value();
                e.setValue(newValue, this.valueType, this.refQueue);
            }
            return oldValue;
        }

        private boolean replaceInternal2(K key, int hash, V oldValue, V newValue) {
            this.removeStale();
            HashEntry e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && this.keyEq(key, e.key()))) {
                e = e.next;
            }
            boolean replaced = false;
            if (e != null && oldValue.equals(e.value())) {
                replaced = true;
                e.setValue(newValue, this.valueType, this.refQueue);
            }
            return replaced;
        }

        void setTable(HashEntry<K, V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
            this.refQueue = new ReferenceQueue();
        }
    }

    public static enum ReferenceType {
        STRONG,
        WEAK,
        SOFT;

    }

    public static class Builder<K, V>
    implements Supplier<ConcurrentReferenceHashMap<K, V>> {
        private static final Map<?, ?> DEFAULT_SOURCE_MAP = null;
        private int initialCapacity = 16;
        private float loadFactor = 0.75f;
        private int concurrencyLevel = 16;
        private ReferenceType keyReferenceType = DEFAULT_KEY_TYPE;
        private ReferenceType valueReferenceType = DEFAULT_VALUE_TYPE;
        private EnumSet<Option> options = DEFAULT_OPTIONS;
        private Map<? extends K, ? extends V> sourceMap = DEFAULT_SOURCE_MAP;

        @Override
        public ConcurrentReferenceHashMap<K, V> get() {
            ConcurrentReferenceHashMap<? extends K, ? extends V> map = new ConcurrentReferenceHashMap<K, V>(this.initialCapacity, this.loadFactor, this.concurrencyLevel, this.keyReferenceType, this.valueReferenceType, this.options);
            if (this.sourceMap != null) {
                map.putAll(this.sourceMap);
            }
            return map;
        }

        public Builder<K, V> setConcurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder<K, V> setKeyReferenceType(ReferenceType keyReferenceType) {
            this.keyReferenceType = keyReferenceType;
            return this;
        }

        public Builder<K, V> setLoadFactor(float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        public Builder<K, V> setOptions(EnumSet<Option> options) {
            this.options = options;
            return this;
        }

        public Builder<K, V> setSourceMap(Map<? extends K, ? extends V> sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        public Builder<K, V> setValueReferenceType(ReferenceType valueReferenceType) {
            this.valueReferenceType = valueReferenceType;
            return this;
        }

        public Builder<K, V> softKeys() {
            this.setKeyReferenceType(ReferenceType.SOFT);
            return this;
        }

        public Builder<K, V> softValues() {
            this.setValueReferenceType(ReferenceType.SOFT);
            return this;
        }

        public Builder<K, V> strongKeys() {
            this.setKeyReferenceType(ReferenceType.STRONG);
            return this;
        }

        public Builder<K, V> strongValues() {
            this.setValueReferenceType(ReferenceType.STRONG);
            return this;
        }

        public Builder<K, V> weakKeys() {
            this.setKeyReferenceType(ReferenceType.WEAK);
            return this;
        }

        public Builder<K, V> weakValues() {
            this.setValueReferenceType(ReferenceType.WEAK);
            return this;
        }
    }

    public static enum Option {
        IDENTITY_COMPARISONS;

    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final boolean cached;

        private EntrySet(boolean cached) {
            this.cached = cached;
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentReferenceHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.cached ? new CachedEntryIterator() : new EntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentReferenceHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentReferenceHashMap.this.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentReferenceHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentReferenceHashMap.this.containsValue(o);
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }
    }

    private final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        private WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            ConcurrentReferenceHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    private static final class WeakValueReference<V>
    extends WeakReference<V>
    implements KeyReference {
        private final Object keyRef;
        private final int hash;

        WeakValueReference(V value, Object keyRef, int hash, ReferenceQueue<Object> refQueue) {
            super(value, refQueue);
            this.keyRef = keyRef;
            this.hash = hash;
        }

        @Override
        public int keyHash() {
            return this.hash;
        }

        @Override
        public Object keyRef() {
            return this.keyRef;
        }
    }

    private static final class WeakKeyReference<K>
    extends WeakReference<K>
    implements KeyReference {
        private final int hash;

        WeakKeyReference(K key, int hash, ReferenceQueue<Object> refQueue) {
            super(key, refQueue);
            this.hash = hash;
        }

        @Override
        public int keyHash() {
            return this.hash;
        }

        @Override
        public Object keyRef() {
            return this;
        }
    }

    private final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value();
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value();
        }
    }

    private static final class SoftValueReference<V>
    extends SoftReference<V>
    implements KeyReference {
        private final Object keyRef;
        private final int hash;

        SoftValueReference(V value, Object keyRef, int hash, ReferenceQueue<Object> refQueue) {
            super(value, refQueue);
            this.keyRef = keyRef;
            this.hash = hash;
        }

        @Override
        public int keyHash() {
            return this.hash;
        }

        @Override
        public Object keyRef() {
            return this.keyRef;
        }
    }

    private static final class SoftKeyReference<K>
    extends SoftReference<K>
    implements KeyReference {
        private final int hash;

        SoftKeyReference(K key, int hash, ReferenceQueue<Object> refQueue) {
            super(key, refQueue);
            this.hash = hash;
        }

        @Override
        public int keyHash() {
            return this.hash;
        }

        @Override
        public Object keyRef() {
            return this;
        }
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static interface KeyReference {
        public int keyHash();

        public Object keyRef();
    }

    private final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().key();
        }

        @Override
        public K nextElement() {
            return super.nextEntry().key();
        }
    }

    private static final class InitializableEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        private InitializableEntry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public Map.Entry<K, V> init(K key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class HashIterator {
        private int nextSegmentIndex;
        private int nextTableIndex;
        private HashEntry<K, V>[] currentTable;
        private HashEntry<K, V> nextEntry;
        private HashEntry<K, V> lastReturned;
        private K currentKey;

        private HashIterator() {
            this.nextSegmentIndex = ConcurrentReferenceHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = ConcurrentReferenceHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReferenceHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    private static final class HashEntry<K, V> {
        private final Object keyRef;
        private final int hash;
        private volatile Object valueRef;
        private final HashEntry<K, V> next;

        static <K, V> HashEntry<K, V>[] newArray(int i) {
            return new HashEntry[i];
        }

        HashEntry(K key, int hash, HashEntry<K, V> next, V value, ReferenceType keyType, ReferenceType valueType, ReferenceQueue<Object> refQueue) {
            this.hash = hash;
            this.next = next;
            this.keyRef = this.newKeyReference(key, keyType, refQueue);
            this.valueRef = this.newValueReference(value, valueType, refQueue);
        }

        V dereferenceValue(Object value) {
            if (value instanceof KeyReference) {
                return (V)((Reference)value).get();
            }
            return (V)value;
        }

        K key() {
            if (this.keyRef instanceof KeyReference) {
                return (K)((Reference)this.keyRef).get();
            }
            return (K)this.keyRef;
        }

        Object newKeyReference(K key, ReferenceType keyType, ReferenceQueue<Object> refQueue) {
            if (keyType == ReferenceType.WEAK) {
                return new WeakKeyReference<K>(key, this.hash, refQueue);
            }
            if (keyType == ReferenceType.SOFT) {
                return new SoftKeyReference<K>(key, this.hash, refQueue);
            }
            return key;
        }

        Object newValueReference(V value, ReferenceType valueType, ReferenceQueue<Object> refQueue) {
            if (valueType == ReferenceType.WEAK) {
                return new WeakValueReference<V>(value, this.keyRef, this.hash, refQueue);
            }
            if (valueType == ReferenceType.SOFT) {
                return new SoftValueReference<V>(value, this.keyRef, this.hash, refQueue);
            }
            return value;
        }

        void setValue(V value, ReferenceType valueType, ReferenceQueue<Object> refQueue) {
            this.valueRef = this.newValueReference(value, valueType, refQueue);
        }

        V value() {
            return this.dereferenceValue(this.valueRef);
        }
    }

    private final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e = super.nextEntry();
            return new WriteThroughEntry(e.key(), e.value());
        }
    }

    private final class CachedEntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        private final InitializableEntry<K, V> entry = new InitializableEntry();

        private CachedEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            HashEntry e = super.nextEntry();
            return this.entry.init(e.key(), e.value());
        }
    }
}

