/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapDecorator;
import org.apache.commons.collections4.multimap.MultiValuedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedMultiValuedMap<K, V>
extends AbstractMultiValuedMapDecorator<K, V> {
    private static final long serialVersionUID = -1254147899086470720L;
    private final Transformer<? super K, ? extends K> keyTransformer;
    private final Transformer<? super V, ? extends V> valueTransformer;

    public static <K, V> TransformedMultiValuedMap<K, V> transformingMap(MultiValuedMap<K, V> map, Transformer<? super K, ? extends K> keyTransformer, Transformer<? super V, ? extends V> valueTransformer) {
        return new TransformedMultiValuedMap<K, V>(map, keyTransformer, valueTransformer);
    }

    public static <K, V> TransformedMultiValuedMap<K, V> transformedMap(MultiValuedMap<K, V> map, Transformer<? super K, ? extends K> keyTransformer, Transformer<? super V, ? extends V> valueTransformer) {
        TransformedMultiValuedMap<K, V> decorated = new TransformedMultiValuedMap<K, V>(map, keyTransformer, valueTransformer);
        if (map.size() > 0) {
            MultiValuedMap<? extends K, ? extends V> transformed = decorated.transformMultiValuedMap(map);
            decorated.clear();
            decorated.decorated().putAll(transformed);
        }
        return decorated;
    }

    protected TransformedMultiValuedMap(MultiValuedMap<K, V> map, Transformer<? super K, ? extends K> keyTransformer, Transformer<? super V, ? extends V> valueTransformer) {
        super(map);
        this.keyTransformer = keyTransformer;
        this.valueTransformer = valueTransformer;
    }

    protected K transformKey(K object) {
        if (this.keyTransformer == null) {
            return object;
        }
        return this.keyTransformer.transform(object);
    }

    protected V transformValue(V object) {
        if (this.valueTransformer == null) {
            return object;
        }
        return this.valueTransformer.transform(object);
    }

    protected Map<K, V> transformMap(Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return map;
        }
        LinkedMap<K, V> result = new LinkedMap<K, V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(this.transformKey(entry.getKey()), this.transformValue(entry.getValue()));
        }
        return result;
    }

    protected MultiValuedMap<K, V> transformMultiValuedMap(MultiValuedMap<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return map;
        }
        MultiValuedHashMap<K, V> result = new MultiValuedHashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entries()) {
            result.put(this.transformKey(entry.getKey()), this.transformValue(entry.getValue()));
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        K transformedKey = this.transformKey(key);
        V transformedValue = this.transformValue(value);
        return this.decorated().put(transformedKey, transformedValue);
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        if (values == null || values.iterator() == null || !values.iterator().hasNext()) {
            return false;
        }
        K transformedKey = this.transformKey(key);
        LinkedList<V> transformedValues = new LinkedList<V>();
        Iterator<V> it = values.iterator();
        while (it.hasNext()) {
            transformedValues.add(this.transformValue(it.next()));
        }
        return this.decorated().putAll(transformedKey, transformedValues);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        this.decorated().putAll(this.transformMap(m));
    }

    @Override
    public void putAll(MultiValuedMap<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        this.decorated().putAll(this.transformMultiValuedMap(m));
    }
}

